/*
 * Decompiled with CFR 0.152.
 */
package io.github.factoryfx.factory.merge;

import io.github.factoryfx.factory.FactoryBase;
import io.github.factoryfx.factory.merge.AttributeDiffInfo;
import io.github.factoryfx.factory.merge.MergeDiffInfo;
import io.github.factoryfx.factory.merge.MergeResult;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.UUID;
import java.util.function.Function;

public final class DataMerger<R extends FactoryBase<?, R>> {
    private final R currentData;
    private final R commonData;
    private final R newData;
    List<Triple> mergeable = new ArrayList<Triple>();

    public DataMerger(R currentData, R commonData, R newData) {
        if (currentData == commonData) {
            throw new IllegalArgumentException("Arguments: currentData and commonData can't be the same, use .utility().copy() to create a copy");
        }
        this.currentData = currentData;
        this.commonData = commonData;
        this.newData = newData;
        ((FactoryBase)currentData).internal().finalise();
        ((FactoryBase)commonData).internal().finalise();
        ((FactoryBase)newData).internal().finalise();
        List currentDataList = ((FactoryBase)currentData).internal().collectChildrenDeep();
        List commonDataList = ((FactoryBase)commonData).internal().collectChildrenDeep();
        List newDataDataList = ((FactoryBase)newData).internal().collectChildrenDeep();
        int matchEnd = -1;
        for (int i = 0; i < currentDataList.size(); ++i) {
            if (i >= commonDataList.size() || i >= newDataDataList.size()) {
                matchEnd = i;
                break;
            }
            FactoryBase currentDataItem = currentDataList.get(i);
            FactoryBase commonDataItem = commonDataList.get(i);
            FactoryBase newDataDataItem = newDataDataList.get(i);
            if (!currentDataItem.getId().equals(commonDataItem.getId()) || !currentDataItem.getId().equals(newDataDataItem.getId())) {
                matchEnd = i;
                break;
            }
            this.mergeable.add(new Triple(currentDataItem, commonDataItem, newDataDataItem));
        }
        HashMap<UUID, FactoryBase> currentDataMap = new HashMap<UUID, FactoryBase>();
        HashMap<UUID, FactoryBase> commonDataMap = new HashMap<UUID, FactoryBase>();
        HashMap<UUID, FactoryBase> newDataDataMap = new HashMap<UUID, FactoryBase>();
        if (matchEnd >= 0) {
            FactoryBase item2;
            int i;
            for (i = matchEnd; i < currentDataList.size(); ++i) {
                item2 = currentDataList.get(i);
                currentDataMap.put(item2.getId(), item2);
            }
            for (i = matchEnd; i < commonDataList.size(); ++i) {
                item2 = commonDataList.get(i);
                commonDataMap.put(item2.getId(), item2);
            }
            for (i = matchEnd; i < newDataDataList.size(); ++i) {
                item2 = newDataDataList.get(i);
                newDataDataMap.put(item2.getId(), item2);
            }
            for (FactoryBase item2 : currentDataMap.values()) {
                if (item2 == currentData) {
                    this.mergeable.add(new Triple(item2, commonData, newData));
                    continue;
                }
                this.mergeable.add(new Triple(item2, (FactoryBase)commonDataMap.get(item2.getId()), (FactoryBase)newDataDataMap.get(item2.getId())));
            }
        }
    }

    public MergeResult<R> createMergeResult(Function<String, Boolean> permissionChecker) {
        MergeResult mergeResult = new MergeResult(this.currentData);
        for (Triple entry : this.mergeable) {
            FactoryBase originalValue = entry.commonFactory;
            FactoryBase newValue = entry.newFactory;
            if (newValue == null && originalValue != null) {
                entry.currentFactory.internal().visitAttributesForMatch(originalValue, (name, currentAttribute, originalAttribute) -> {
                    if (!currentAttribute.internal_mergeMatch(originalAttribute)) {
                        mergeResult.addConflictInfo(new AttributeDiffInfo(name, entry.currentFactory.getId()));
                    }
                    return true;
                });
            }
            if (originalValue == null || newValue == null) continue;
            FactoryBase value = entry.currentFactory;
            value.internal().merge(originalValue, newValue, mergeResult, permissionChecker);
        }
        return mergeResult;
    }

    public MergeDiffInfo<R> mergeIntoCurrent(Function<String, Boolean> permissionChecker) {
        return this.createMergeResult(permissionChecker).executeMerge();
    }

    private static class Triple<R extends FactoryBase<?, R>> {
        private final FactoryBase<?, R> currentFactory;
        private final FactoryBase<?, R> commonFactory;
        private final FactoryBase<?, R> newFactory;

        private Triple(FactoryBase<?, R> currentFactory, FactoryBase<?, R> commonFactory, FactoryBase<?, R> newFactory) {
            this.currentFactory = currentFactory;
            this.commonFactory = commonFactory;
            this.newFactory = newFactory;
        }
    }
}

