/*
 * Decompiled with CFR 0.152.
 */
package io.github.factoryfx.factory.merge;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.github.factoryfx.factory.FactoryBase;
import io.github.factoryfx.factory.jackson.ObjectMapperBuilder;
import io.github.factoryfx.factory.merge.AttributeDiffInfo;
import java.util.List;

public class MergeDiffInfo<R extends FactoryBase<?, ?>> {
    @JsonProperty
    private final Class<R> rootClazz;
    public final List<AttributeDiffInfo> mergeInfos;
    public final List<AttributeDiffInfo> conflictInfos;
    public final List<AttributeDiffInfo> permissionViolations;
    @JsonIgnore
    private final R previousRoot;
    @JsonIgnore
    private final R newRoot;

    @JsonCreator
    public MergeDiffInfo(@JsonProperty(value="mergeInfos") List<AttributeDiffInfo> mergeInfos, @JsonProperty(value="conflictInfos") List<AttributeDiffInfo> conflictInfos, @JsonProperty(value="permissionViolations") List<AttributeDiffInfo> permissionViolations, @JsonProperty(value="previousRoot") String previousRoot, @JsonProperty(value="newRoot") String newRoot, @JsonProperty(value="rootClazz") Class<R> rootClazz) {
        this.mergeInfos = mergeInfos;
        this.conflictInfos = conflictInfos;
        this.permissionViolations = permissionViolations;
        this.previousRoot = (FactoryBase)ObjectMapperBuilder.build().readValue(previousRoot, rootClazz);
        this.newRoot = (FactoryBase)ObjectMapperBuilder.build().readValue(newRoot, rootClazz);
        this.rootClazz = rootClazz;
    }

    public MergeDiffInfo(List<AttributeDiffInfo> mergeInfos, List<AttributeDiffInfo> conflictInfos, List<AttributeDiffInfo> permissionViolations, R previousRoot, R newRoot, Class<R> rootClazz) {
        this.mergeInfos = mergeInfos;
        this.conflictInfos = conflictInfos;
        this.permissionViolations = permissionViolations;
        this.previousRoot = previousRoot;
        this.newRoot = newRoot;
        this.rootClazz = rootClazz;
    }

    public String getPreviousRoot() {
        return ObjectMapperBuilder.build().writeValueAsString(this.previousRoot);
    }

    public String getNewRoot() {
        return ObjectMapperBuilder.build().writeValueAsString(this.newRoot);
    }

    @JsonIgnore
    public int getConflictCount() {
        return this.conflictInfos.size();
    }

    @JsonIgnore
    public boolean hasNoConflicts() {
        return this.conflictInfos.isEmpty();
    }

    @JsonIgnore
    public boolean hasNoPermissionViolation() {
        return this.permissionViolations.isEmpty();
    }

    @JsonIgnore
    public boolean successfullyMerged() {
        return this.hasNoConflicts() && this.hasNoPermissionViolation();
    }

    @JsonIgnore
    public R getPreviousRootData() {
        return this.previousRoot;
    }

    @JsonIgnore
    public R getNewRootData() {
        return this.newRoot;
    }
}

