/*
 * Decompiled with CFR 0.152.
 */
package io.github.factoryfx.factory.merge;

import io.github.factoryfx.factory.FactoryBase;
import io.github.factoryfx.factory.merge.AttributeDiffInfo;
import io.github.factoryfx.factory.merge.MergeDiffInfo;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class MergeResult<R extends FactoryBase<?, R>> {
    final R previousRoot;
    final R currentRoot;
    final List<AttributeDiffInfo> mergeInfos = new ArrayList<AttributeDiffInfo>();
    final List<AttributeDiffInfo> conflictInfos = new ArrayList<AttributeDiffInfo>();
    final List<AttributeDiffInfo> mergePermissionViolations = new ArrayList<AttributeDiffInfo>();
    final List<Runnable> mergeExecutions = new ArrayList<Runnable>();
    private HashSet<FactoryBase<?, R>> mergedFactories = new HashSet();

    public MergeResult(R currentRoot) {
        this.previousRoot = ((FactoryBase)currentRoot).internal().copy();
        this.currentRoot = currentRoot;
    }

    public void addConflictInfo(AttributeDiffInfo conflictInfo) {
        this.conflictInfos.add(conflictInfo);
    }

    public void addMergeExecutions(Runnable mergeAction, FactoryBase<?, R> mergeTarget) {
        this.mergeExecutions.add(mergeAction);
        this.mergedFactories.add(mergeTarget);
    }

    public void addMergeInfo(AttributeDiffInfo mergeInfo) {
        this.mergeInfos.add(mergeInfo);
    }

    public void addPermissionViolationInfo(AttributeDiffInfo permissionViolation) {
        this.mergePermissionViolations.add(permissionViolation);
    }

    public MergeDiffInfo<R> executeMerge() {
        if (this.hasNoConflicts() && this.hasNoPermissionViolation()) {
            for (Runnable mergeAction : this.mergeExecutions) {
                mergeAction.run();
            }
            ((FactoryBase)this.currentRoot).internal().needRecalculationForBackReferences();
            ((FactoryBase)this.currentRoot).internal().finalise();
            ((FactoryBase)this.currentRoot).internal().fixDuplicateFactories();
        }
        return new MergeDiffInfo<R>(this.mergeInfos, this.conflictInfos, this.mergePermissionViolations, this.previousRoot, this.currentRoot, this.currentRoot.getClass());
    }

    private boolean hasNoPermissionViolation() {
        return this.mergePermissionViolations.isEmpty();
    }

    private boolean hasNoConflicts() {
        return this.conflictInfos.isEmpty();
    }

    public Set<FactoryBase<?, R>> getMergedFactories() {
        return this.mergedFactories;
    }
}

