/*
 * Decompiled with CFR 0.152.
 */
package io.github.factoryfx.factory.metadata;

import io.github.factoryfx.factory.AttributeVisitor;
import io.github.factoryfx.factory.FactoryBase;
import io.github.factoryfx.factory.FactoryEnclosingAttributeVisitor;
import io.github.factoryfx.factory.attribute.Attribute;
import io.github.factoryfx.factory.attribute.dependency.FactoryChildrenEnclosingAttribute;
import io.github.factoryfx.factory.attribute.dependency.ReferenceBaseAttribute;
import io.github.factoryfx.factory.fastfactory.FastFactoryUtility;
import io.github.factoryfx.factory.metadata.AttributeFieldAccessor;
import io.github.factoryfx.factory.storage.migration.metadata.AttributeStorageMetadata;
import io.github.factoryfx.factory.storage.migration.metadata.DataStorageMetadata;
import java.lang.invoke.MethodHandles;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InaccessibleObjectException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Modifier;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Stream;

public class FactoryMetadata<R extends FactoryBase<?, R>, L, F extends FactoryBase<L, R>> {
    private boolean temporaryAttributes = false;
    private Constructor constructor;
    private final Class<? extends FactoryBase<?, ?>> clazz;
    private FastFactoryUtility<R, F> fastFactoryUtility;
    private final ArrayList<Field> attributeFields = new ArrayList();
    private final HashMap<String, Class<?>> fieldToReferenceClass = new HashMap();
    private final ArrayList<AttributeFieldAccessor<R, L, F, FactoryChildrenEnclosingAttribute<R, ?>>> factoryChildrenEnclosingAttributeFields = new ArrayList();
    private static Object[] defaultConstructor = new Object[0];
    private Function<F, F> newCopyInstanceSupplier = null;

    public FactoryMetadata(Class<F> clazz) {
        this.clazz = clazz;
        this.initAttributeFields(clazz);
        for (Field attributeField : this.attributeFields) {
            if (!attributeField.getName().equals("id")) continue;
            throw new IllegalStateException(clazz.getName() + ", Factories can't have an id attribute because that conflicts with the factory id property");
        }
    }

    public FactoryMetadata<R, L, F> setUseTemporaryAttributes() {
        this.temporaryAttributes = true;
        return this;
    }

    public void visitAttributesFlat(F data, AttributeVisitor attributeVisitor) {
        if (this.fastFactoryUtility != null) {
            this.fastFactoryUtility.visitAttributesFlat(data, attributeVisitor);
        } else {
            for (Field field : this.attributeFields) {
                try {
                    attributeVisitor.accept(field.getName(), (Attribute)field.get(data));
                }
                catch (IllegalAccessException e) {
                    throw new RuntimeException("\nto fix the error add jpms boilerplate, \noption 1: module-info.info: opens " + data.getClass().getPackage().getName() + ";\noption 2: open all, open module {A} { ... } (open keyword before module)\n", e);
                }
            }
        }
    }

    public void visitFactoryEnclosingAttributesFlat(F factory, FactoryEnclosingAttributeVisitor<R> visitor) {
        for (AttributeFieldAccessor<R, L, F, FactoryChildrenEnclosingAttribute<R, ?>> attributeFieldAccessor : this.factoryChildrenEnclosingAttributeFields) {
            visitor.accept(attributeFieldAccessor.getName(), attributeFieldAccessor.get(factory));
        }
    }

    public void setFastFactoryUtility(FastFactoryUtility<R, F> fastFactoryUtility) {
        this.fastFactoryUtility = fastFactoryUtility;
    }

    public <V> void visitAttributesForCopy(F factory, F other, FactoryBase.BiCopyAttributeVisitor<V> consumer) {
        if (this.fastFactoryUtility != null) {
            this.fastFactoryUtility.visitAttributesForCopy(factory, other, consumer);
        } else {
            for (Field field : this.attributeFields) {
                try {
                    if (consumer.accept((Attribute)field.get(factory), (Attribute)field.get(other))) continue;
                    break;
                }
                catch (IllegalAccessException e) {
                    throw new RuntimeException(e);
                }
            }
        }
    }

    public <V> void visitAttributesForMatch(F factory, F other, FactoryBase.AttributeMatchVisitor<V> consumer) {
        if (this.fastFactoryUtility != null) {
            this.fastFactoryUtility.visitAttributesForMatch(factory, other, consumer);
        } else {
            for (Field field : this.attributeFields) {
                try {
                    if (consumer.accept(field.getName(), (Attribute)field.get(factory), (Attribute)field.get(other))) continue;
                    break;
                }
                catch (IllegalAccessException e) {
                    throw new RuntimeException(e);
                }
            }
        }
    }

    public <V> void visitAttributesTripleFlat(F data, F other1, F other2, FactoryBase.TriAttributeVisitor<V> consumer) {
        if (this.fastFactoryUtility != null) {
            this.fastFactoryUtility.visitAttributesTripleFlat(data, other1, other2, consumer);
        } else {
            for (Field field : this.attributeFields) {
                try {
                    consumer.accept(field.getName(), (Attribute)field.get(data), (Attribute)field.get(other1), (Attribute)field.get(other2));
                }
                catch (IllegalAccessException e) {
                    throw new RuntimeException(e);
                }
            }
        }
    }

    private void initAttributeFields(Class<?> clazz) {
        Class<?> parent = clazz.getSuperclass();
        if (parent != null) {
            this.initAttributeFields(parent);
        }
        Stream.of(clazz.getDeclaredFields()).filter(f -> Modifier.isPublic(f.getModifiers())).filter(f -> !Modifier.isStatic(f.getModifiers())).filter(f -> Attribute.class.isAssignableFrom(f.getType())).forEach(this.attributeFields::add);
        MethodHandles.Lookup lookup = MethodHandles.lookup();
        for (Field field : this.attributeFields) {
            try {
                field.setAccessible(true);
            }
            catch (InaccessibleObjectException e) {
                throw new RuntimeException("\n\nto fix the error add jpms boilerplate, \noption 1: module-info.info: opens " + clazz.getPackage().getName() + ";\noption 2: open all, open module {A} { ... } (open keyword before module)\n", e);
            }
            if (FactoryChildrenEnclosingAttribute.class.isAssignableFrom(field.getType())) {
                try {
                    this.factoryChildrenEnclosingAttributeFields.add(new AttributeFieldAccessor(lookup.unreflectGetter(field), field.getName()));
                }
                catch (IllegalAccessException e) {
                    throw new RuntimeException(e);
                }
            }
            if (!ReferenceBaseAttribute.class.isAssignableFrom(field.getType())) continue;
            field.getType().getGenericSuperclass();
            Type type = field.getGenericType();
            if (!(type instanceof ParameterizedType)) continue;
            ParameterizedType ptype = (ParameterizedType)type;
            try {
                Type actualTypeArgument = ptype.getActualTypeArguments()[ptype.getActualTypeArguments().length - 1];
                String className = actualTypeArgument.getTypeName();
                if (actualTypeArgument instanceof ParameterizedType) {
                    className = ((ParameterizedType)actualTypeArgument).getRawType().getTypeName();
                }
                this.fieldToReferenceClass.put(field.getName(), Class.forName(className));
            }
            catch (ClassNotFoundException e) {
                throw new RuntimeException(e);
            }
        }
    }

    public void addBackReferencesAndReferenceClassToAttributes(F data, R root) {
        if (!this.temporaryAttributes) {
            this.visitFactoryEnclosingAttributesFlat(data, (attributeVariableName, attribute) -> {
                attribute.internal_addBackReferences((FactoryBase<?, ?>)root, (FactoryBase<?, ?>)data);
                attribute.internal_setReferenceClass(this.fieldToReferenceClass.get(attributeVariableName));
            });
        }
    }

    public void addBackReferencesAndReferenceClassToAttributesUnsafe(FactoryBase<?, R> data, R root) {
        this.addBackReferencesAndReferenceClassToAttributes(data, root);
    }

    public FactoryMetadata<R, L, F> setNewCopyInstanceSupplier(Function<F, F> newCopyInstanceSupplier) {
        this.newCopyInstanceSupplier = newCopyInstanceSupplier;
        return this;
    }

    public F newCopyInstance(F data) {
        FactoryBase result;
        if (this.newCopyInstanceSupplier != null && data != null) {
            result = (FactoryBase)this.newCopyInstanceSupplier.apply(data);
        } else {
            if (this.constructor == null) {
                try {
                    this.constructor = this.clazz.getDeclaredConstructor(new Class[0]);
                    this.constructor.setAccessible(true);
                }
                catch (NoSuchMethodException e) {
                    throw new RuntimeException("no constructor found, for nested classes ensure that they are static", e);
                }
                catch (InaccessibleObjectException e) {
                    throw new RuntimeException("\n\nto fix the error add jpms boilerplate, \noption 1: module-info.info: opens " + this.clazz.getPackage().getName() + ";\noption 2: open all, open module {A} { ... } (open keyword before module)\n", e);
                }
            }
            try {
                result = (FactoryBase)this.constructor.newInstance(defaultConstructor);
            }
            catch (IllegalAccessException | InstantiationException | InvocationTargetException e) {
                throw new RuntimeException(this.clazz.getName(), e);
            }
        }
        return (F)result;
    }

    public F newInstance() {
        return this.newCopyInstance(null);
    }

    public void setAttributeReferenceClasses(F data) {
        if (!this.temporaryAttributes) {
            this.visitAttributesFlat(data, (attributeVariableName, attribute) -> {
                if (attribute instanceof ReferenceBaseAttribute) {
                    ((ReferenceBaseAttribute)attribute).internal_setReferenceClass(this.fieldToReferenceClass.get(attributeVariableName));
                }
            });
        }
    }

    public DataStorageMetadata createDataStorageMetadata(long count) {
        F data = this.newInstance();
        this.setAttributeReferenceClasses(data);
        ArrayList<AttributeStorageMetadata> attributes = new ArrayList<AttributeStorageMetadata>();
        this.visitAttributesFlat(data, (attributeVariableName, attribute) -> attributes.add(attribute.createAttributeStorageMetadata(attributeVariableName)));
        return new DataStorageMetadata(attributes, this.clazz.getName(), count);
    }

    public void visitChildFactoriesAndViewsFlat(F factory, Consumer<FactoryBase<?, R>> consumer, boolean includeViews) {
        if (this.fastFactoryUtility != null) {
            this.fastFactoryUtility.visitChildFactoriesAndViewsFlat(factory, consumer);
        } else {
            this.visitFactoryEnclosingAttributesFlat(factory, (attributeVariableName, attribute) -> attribute.internal_visitChildren(consumer, includeViews));
        }
    }

    public static class AttributeNamePair {
        public final String name;
        public final Attribute<?, ?> attribute;

        public AttributeNamePair(String name, Attribute<?, ?> attribute) {
            this.name = name;
            this.attribute = attribute;
        }
    }
}

