/*
 * Decompiled with CFR 0.152.
 */
package io.github.factoryfx.factory.storage;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import io.github.factoryfx.factory.FactoryBase;
import io.github.factoryfx.factory.storage.StoredDataMetadata;
import java.time.LocalDateTime;
import java.util.UUID;
import java.util.function.Function;

@JsonInclude(value=JsonInclude.Include.NON_EMPTY)
public class DataUpdate<R extends FactoryBase<?, ?>> {
    @JsonTypeInfo(use=JsonTypeInfo.Id.CLASS, include=JsonTypeInfo.As.PROPERTY, property="@class")
    public final R root;
    public String user;
    public String comment;
    public final String baseVersionId;
    @JsonIgnore
    public Function<String, Boolean> permissionChecker = p -> true;

    @JsonCreator
    public DataUpdate(@JsonProperty(value="root") R root, @JsonProperty(value="user") String user, @JsonProperty(value="comment") String comment, @JsonProperty(value="baseVersionId") String baseVersionId) {
        this.root = root;
        this.user = user;
        this.comment = comment;
        this.baseVersionId = baseVersionId;
    }

    public <S> StoredDataMetadata<S> createUpdateStoredDataMetadata(S changeSummary, String mergerVersionId) {
        return new StoredDataMetadata<S>(LocalDateTime.now(), UUID.randomUUID().toString(), this.user, this.comment, this.baseVersionId, changeSummary, ((FactoryBase)this.root).internal().createDataStorageMetadataDictionaryFromRoot(), mergerVersionId);
    }
}

