/*
 * Decompiled with CFR 0.152.
 */
package io.github.factoryfx.factory.storage;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.github.factoryfx.factory.storage.migration.metadata.DataStorageMetadataDictionary;
import java.time.LocalDateTime;
import java.time.temporal.ChronoUnit;
import java.util.concurrent.Delayed;
import java.util.concurrent.TimeUnit;

public class ScheduledUpdateMetadata
implements Delayed {
    public final String id;
    public final String user;
    public final String comment;
    public final LocalDateTime scheduled;
    public final DataStorageMetadataDictionary dataStorageMetadataDictionary;

    @JsonCreator
    public ScheduledUpdateMetadata(@JsonProperty(value="id") String id, @JsonProperty(value="user") String user, @JsonProperty(value="comment") String comment, @JsonProperty(value="scheduled") LocalDateTime scheduled, @JsonProperty(value="dataStorageMetadataDictionary") DataStorageMetadataDictionary dataStorageMetadataDictionary) {
        this.id = id;
        this.scheduled = scheduled;
        this.user = user;
        this.comment = comment;
        this.dataStorageMetadataDictionary = dataStorageMetadataDictionary;
    }

    @Override
    @JsonIgnore
    public long getDelay(TimeUnit unit) {
        return this.convert(unit).between(LocalDateTime.now(), this.scheduled);
    }

    @Override
    @JsonIgnore
    public int compareTo(Delayed o) {
        return this.scheduled.compareTo(((ScheduledUpdateMetadata)o).scheduled);
    }

    private ChronoUnit convert(TimeUnit unit) {
        return unit.toChronoUnit();
    }
}

