/*
 * Decompiled with CFR 0.152.
 */
package io.github.factoryfx.factory.storage.filesystem;

import com.fasterxml.jackson.databind.JsonNode;
import io.github.factoryfx.factory.FactoryBase;
import io.github.factoryfx.factory.jackson.SimpleObjectMapper;
import io.github.factoryfx.factory.storage.DataAndId;
import io.github.factoryfx.factory.storage.DataStorage;
import io.github.factoryfx.factory.storage.DataStoragePatcher;
import io.github.factoryfx.factory.storage.DataUpdate;
import io.github.factoryfx.factory.storage.ScheduledUpdate;
import io.github.factoryfx.factory.storage.ScheduledUpdateMetadata;
import io.github.factoryfx.factory.storage.StoredDataMetadata;
import io.github.factoryfx.factory.storage.filesystem.FileSystemFactoryStorageHistory;
import io.github.factoryfx.factory.storage.migration.MigrationManager;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.time.LocalDateTime;
import java.util.Collection;
import java.util.UUID;

public class FileSystemDataStorage<R extends FactoryBase<?, R>, S>
implements DataStorage<R, S> {
    private final FileSystemFactoryStorageHistory<R, S> fileSystemFactoryStorageHistory;
    private final R initialData;
    private final Path currentFactoryPath;
    private final Path currentFactoryPathMetadata;
    private final MigrationManager<R, S> migrationManager;
    private final SimpleObjectMapper objectMapper;

    public FileSystemDataStorage(Path basePath, R initialData, MigrationManager<R, S> migrationManager, FileSystemFactoryStorageHistory<R, S> fileSystemFactoryStorageHistory, SimpleObjectMapper objectMapper) {
        this.initialData = initialData;
        if (!Files.exists(basePath, new LinkOption[0])) {
            throw new IllegalArgumentException("path don't exists:" + basePath);
        }
        this.currentFactoryPath = Paths.get(basePath.toString() + "/currentFactory.json", new String[0]);
        this.currentFactoryPathMetadata = Paths.get(basePath.toString() + "/currentFactory_metadata.json", new String[0]);
        this.fileSystemFactoryStorageHistory = fileSystemFactoryStorageHistory;
        this.migrationManager = migrationManager;
        this.objectMapper = objectMapper;
    }

    public FileSystemDataStorage(Path basePath, R initialData, MigrationManager<R, S> migrationManager, SimpleObjectMapper objectMapper) {
        this(basePath, initialData, migrationManager, new FileSystemFactoryStorageHistory<R, S>(basePath, migrationManager), objectMapper);
    }

    public FileSystemDataStorage(Path basePath, R initialData, MigrationManager<R, S> migrationManager, SimpleObjectMapper objectMapper, int maxConfigurationHistory) {
        this(basePath, initialData, migrationManager, new FileSystemFactoryStorageHistory<R, S>(basePath, migrationManager, maxConfigurationHistory), objectMapper);
    }

    @Override
    public R getHistoryData(String id) {
        return this.fileSystemFactoryStorageHistory.getHistoryFactory(id);
    }

    @Override
    public Collection<StoredDataMetadata<S>> getHistoryDataList() {
        return this.fileSystemFactoryStorageHistory.getHistoryFactoryList();
    }

    @Override
    public Collection<ScheduledUpdateMetadata> getFutureDataList() {
        throw new UnsupportedOperationException();
    }

    @Override
    public void deleteFutureData(String id) {
        throw new UnsupportedOperationException();
    }

    @Override
    public R getFutureData(String id) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void addFutureData(ScheduledUpdate<R> futureFactory) {
        throw new UnsupportedOperationException();
    }

    @Override
    public DataAndId<R> getCurrentData() {
        this.loadInitialFactory();
        StoredDataMetadata<S> storedDataMetadata = this.migrationManager.readStoredFactoryMetadata(this.readFile(this.currentFactoryPathMetadata));
        return new DataAndId<R>(this.migrationManager.read(this.readFile(this.currentFactoryPath), storedDataMetadata.dataStorageMetadataDictionary), storedDataMetadata.id);
    }

    @Override
    public void updateCurrentData(DataUpdate<R> update, S changeSummary) {
        StoredDataMetadata<S> metadata = new StoredDataMetadata<S>(UUID.randomUUID().toString(), update.user, update.comment, update.baseVersionId, changeSummary, ((FactoryBase)update.root).internal().createDataStorageMetadataDictionaryFromRoot(), this.getCurrentData().id);
        this.update(update.root, metadata);
    }

    @Override
    public void patchAll(DataStoragePatcher consumer) {
        this.patchCurrentData(consumer);
        this.fileSystemFactoryStorageHistory.patchAll(consumer, this.objectMapper);
    }

    @Override
    public void patchCurrentData(DataStoragePatcher consumer) {
        JsonNode data = this.objectMapper.readTree(this.currentFactoryPath);
        JsonNode metadata = this.objectMapper.readTree(this.currentFactoryPathMetadata);
        consumer.patch(data, metadata);
        this.writeFile(this.currentFactoryPath, this.objectMapper.writeTree(data));
        this.writeFile(this.currentFactoryPathMetadata, this.objectMapper.writeTree(metadata));
    }

    private void update(R update, StoredDataMetadata<S> metadata) {
        this.writeFile(this.currentFactoryPath, this.migrationManager.write(update));
        this.writeFile(this.currentFactoryPathMetadata, this.migrationManager.writeStorageMetadata(metadata));
        this.fileSystemFactoryStorageHistory.updateHistory(update, metadata);
    }

    private void loadInitialFactory() {
        if (!Files.exists(this.currentFactoryPath, new LinkOption[0])) {
            StoredDataMetadata<Object> metadata = new StoredDataMetadata<Object>(LocalDateTime.now(), UUID.randomUUID().toString(), "System", "initial factory", UUID.randomUUID().toString(), null, ((FactoryBase)this.initialData).internal().createDataStorageMetadataDictionaryFromRoot(), null);
            this.update(this.initialData, metadata);
        }
    }

    private String readFile(Path path) {
        try {
            return Files.readString(path);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private void writeFile(Path path, String content) {
        try {
            Files.writeString(path, (CharSequence)content, new OpenOption[0]);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }
}

