/*
 * Decompiled with CFR 0.152.
 */
package io.github.factoryfx.factory.storage.filesystem;

import com.fasterxml.jackson.databind.JsonNode;
import io.github.factoryfx.factory.FactoryBase;
import io.github.factoryfx.factory.jackson.SimpleObjectMapper;
import io.github.factoryfx.factory.storage.DataStoragePatcher;
import io.github.factoryfx.factory.storage.StoredDataMetadata;
import io.github.factoryfx.factory.storage.migration.MigrationManager;
import java.io.IOException;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FileSystemFactoryStorageHistory<R extends FactoryBase<?, R>, S> {
    private static final Logger logger = LoggerFactory.getLogger(FileSystemFactoryStorageHistory.class);
    private final Map<String, StoredDataMetadata<S>> cache = new TreeMap<String, StoredDataMetadata<S>>();
    private final Path historyDirectory;
    private final MigrationManager<R, S> migrationManager;
    private final int maxConfigurationHistory;

    public FileSystemFactoryStorageHistory(Path basePath, MigrationManager<R, S> migrationManager) {
        this(basePath, migrationManager, Integer.MAX_VALUE);
    }

    public FileSystemFactoryStorageHistory(Path basePath, MigrationManager<R, S> migrationManager, int maxConfigurationHistory) {
        this.migrationManager = migrationManager;
        this.historyDirectory = basePath.resolve("history");
        this.maxConfigurationHistory = maxConfigurationHistory;
        if (!Files.exists(this.historyDirectory, new LinkOption[0])) {
            try {
                Files.createDirectories(this.historyDirectory, new FileAttribute[0]);
            }
            catch (IOException e) {
                throw new IllegalStateException("Unable to create path" + this.historyDirectory.toFile().getAbsolutePath(), e);
            }
        }
    }

    public R getHistoryFactory(String id) {
        StoredDataMetadata<S> storedDataMetadata = null;
        for (StoredDataMetadata<S> metaData : this.getHistoryFactoryList()) {
            if (!metaData.id.equals(id)) continue;
            storedDataMetadata = metaData;
        }
        if (storedDataMetadata == null) {
            throw new IllegalStateException("cant find storedDataMetadata for factory: " + id + " in history");
        }
        return this.migrationManager.read(this.readFile(Paths.get(this.historyDirectory.toString() + "/" + id + ".json", new String[0])), storedDataMetadata.dataStorageMetadataDictionary);
    }

    private void visitHistoryFiles(Consumer<Path> visitor) {
        try (Stream<Path> files = Files.walk(this.historyDirectory, new FileVisitOption[0]).filter(x$0 -> Files.isRegularFile(x$0, new LinkOption[0]));){
            files.forEach(visitor);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public Collection<StoredDataMetadata<S>> getHistoryFactoryList() {
        if (this.cache.isEmpty()) {
            this.visitHistoryFiles(path -> {
                if (path.toString().endsWith("_metadata.json")) {
                    StoredDataMetadata<S> storedDataMetadata = this.migrationManager.readStoredFactoryMetadata(this.readFile((Path)path));
                    this.cache.put(storedDataMetadata.id, storedDataMetadata);
                }
            });
        }
        return this.cache.values();
    }

    public void updateHistory(R factoryRoot, StoredDataMetadata<S> metadata) {
        String id = metadata.id;
        this.writeFile(Paths.get(this.historyDirectory.toString() + "/" + id + ".json", new String[0]), this.migrationManager.write(factoryRoot));
        this.writeFile(Paths.get(this.historyDirectory.toString() + "/" + id + "_metadata.json", new String[0]), this.migrationManager.writeStorageMetadata(metadata));
        this.cache.put(id, metadata);
        this.houseKeeping();
    }

    private String readFile(Path path) {
        try {
            return Files.readString(path);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private void writeFile(Path path, String content) {
        try {
            Files.writeString(path, (CharSequence)content, new OpenOption[0]);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public void patchAll(DataStoragePatcher consumer, SimpleObjectMapper simpleObjectMapper) {
        this.visitHistoryFiles(path -> {
            if (!path.toString().endsWith("_metadata.json")) {
                JsonNode data = simpleObjectMapper.readTree((Path)path);
                Path metadataPath = path.resolveSibling(path.getParent().resolve(path.getFileName().toString().replace(".json", "_metadata.json")));
                JsonNode metadata = simpleObjectMapper.readTree(metadataPath);
                consumer.patch(data, metadata);
                this.writeFile((Path)path, simpleObjectMapper.writeTree(data));
                this.writeFile(metadataPath, simpleObjectMapper.writeTree(metadata));
            }
        });
    }

    private void houseKeeping() {
        if (this.maxConfigurationHistory == Integer.MAX_VALUE) {
            return;
        }
        List collect = this.getHistoryFactoryList().stream().collect(Collectors.toList());
        int numToRemove = collect.size() - this.maxConfigurationHistory;
        if (numToRemove > 0) {
            collect.stream().sorted(Comparator.comparing(a -> a.creationTime)).limit(numToRemove).forEach(smd -> {
                try {
                    Files.deleteIfExists(Paths.get(this.historyDirectory.toString() + "/" + smd.id + ".json", new String[0]));
                    Files.deleteIfExists(Paths.get(this.historyDirectory.toString() + "/" + smd.id + "_metadata.json", new String[0]));
                    this.cache.remove(smd.id);
                }
                catch (IOException ohno) {
                    logger.warn("Could not remove configration files", (Throwable)ohno);
                }
            });
        }
    }
}

