/*
 * Decompiled with CFR 0.152.
 */
package io.github.factoryfx.factory.storage.inmemory;

import io.github.factoryfx.factory.FactoryBase;
import io.github.factoryfx.factory.storage.DataAndId;
import io.github.factoryfx.factory.storage.DataAndStoredMetadata;
import io.github.factoryfx.factory.storage.DataStorage;
import io.github.factoryfx.factory.storage.DataStoragePatcher;
import io.github.factoryfx.factory.storage.DataUpdate;
import io.github.factoryfx.factory.storage.ScheduledUpdate;
import io.github.factoryfx.factory.storage.ScheduledUpdateMetadata;
import io.github.factoryfx.factory.storage.StoredDataMetadata;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import java.util.TreeMap;
import java.util.UUID;
import java.util.stream.Collectors;

public class InMemoryDataStorage<R extends FactoryBase<?, ?>, S>
implements DataStorage<R, S> {
    private final Map<String, DataAndStoredMetadata<R, S>> storage = new TreeMap<String, DataAndStoredMetadata<R, S>>();
    private final Map<String, ScheduledUpdate<R>> future = new TreeMap<String, ScheduledUpdate<R>>();
    private String currentFactoryId;

    public InMemoryDataStorage(R initialFactory) {
        ((FactoryBase)initialFactory).internal().finalise();
        this.currentFactoryId = UUID.randomUUID().toString();
        StoredDataMetadata<Object> metadata = new StoredDataMetadata<Object>(this.currentFactoryId, "System", "initial", this.currentFactoryId, null, null, null);
        this.storage.put(this.currentFactoryId, new DataAndStoredMetadata<R, Object>(initialFactory, metadata));
    }

    @Override
    public R getHistoryData(String id) {
        DataAndStoredMetadata<R, S> data = this.storage.get(id);
        return (R)((FactoryBase)data.root).utility().copy();
    }

    @Override
    public Collection<StoredDataMetadata<S>> getHistoryDataList() {
        return this.storage.values().stream().map(item -> item.metadata).collect(Collectors.toList());
    }

    @Override
    public DataAndId<R> getCurrentData() {
        return new DataAndId(((FactoryBase)this.storage.get((Object)this.currentFactoryId).root).utility().copy(), this.currentFactoryId);
    }

    @Override
    public void updateCurrentData(DataUpdate<R> update, S changeSummary) {
        StoredDataMetadata<S> metadata = new StoredDataMetadata<S>(LocalDateTime.now(), UUID.randomUUID().toString(), update.user, update.comment, update.baseVersionId, changeSummary, ((FactoryBase)update.root).internal().createDataStorageMetadataDictionaryFromRoot(), this.currentFactoryId);
        this.storage.put(metadata.id, new DataAndStoredMetadata(update.root, metadata));
        this.currentFactoryId = metadata.id;
    }

    @Override
    public void patchAll(DataStoragePatcher consumer) {
        throw new UnsupportedOperationException("in memory format can't be outdated");
    }

    @Override
    public void patchCurrentData(DataStoragePatcher consumer) {
        throw new UnsupportedOperationException("in memory format can't be outdated");
    }

    @Override
    public Collection<ScheduledUpdateMetadata> getFutureDataList() {
        ArrayList<ScheduledUpdateMetadata> result = new ArrayList<ScheduledUpdateMetadata>();
        for (Map.Entry<String, ScheduledUpdate<R>> entry : this.future.entrySet()) {
            result.add(new ScheduledUpdateMetadata(entry.getKey(), entry.getValue().user, entry.getValue().comment, entry.getValue().scheduled, null));
        }
        return result;
    }

    @Override
    public void deleteFutureData(String id) {
        this.future.remove(id);
    }

    @Override
    public R getFutureData(String id) {
        ScheduledUpdate<R> data = this.future.get(id);
        return (R)((FactoryBase)data.root).utility().copy();
    }

    @Override
    public void addFutureData(ScheduledUpdate<R> futureFactory) {
        this.future.put(UUID.randomUUID().toString(), futureFactory);
    }
}

