/*
 * Decompiled with CFR 0.152.
 */
package io.github.factoryfx.factory.storage.migration;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.google.common.base.Throwables;
import io.github.factoryfx.factory.DataObjectIdResolver;
import io.github.factoryfx.factory.FactoryBase;
import io.github.factoryfx.factory.attribute.Attribute;
import io.github.factoryfx.factory.jackson.SimpleObjectMapper;
import io.github.factoryfx.factory.storage.RawFactoryDataAndMetadata;
import io.github.factoryfx.factory.storage.ScheduledUpdateMetadata;
import io.github.factoryfx.factory.storage.StoredDataMetadata;
import io.github.factoryfx.factory.storage.migration.datamigration.AttributeFiller;
import io.github.factoryfx.factory.storage.migration.datamigration.AttributePathTarget;
import io.github.factoryfx.factory.storage.migration.datamigration.AttributeRename;
import io.github.factoryfx.factory.storage.migration.datamigration.ClassRename;
import io.github.factoryfx.factory.storage.migration.datamigration.DataJsonNode;
import io.github.factoryfx.factory.storage.migration.datamigration.DataMigration;
import io.github.factoryfx.factory.storage.migration.datamigration.PathDataRestore;
import io.github.factoryfx.factory.storage.migration.datamigration.SingletonDataRestore;
import io.github.factoryfx.factory.storage.migration.metadata.DataStorageMetadataDictionary;
import java.util.ArrayList;
import java.util.List;
import java.util.function.BiConsumer;
import java.util.function.Function;

public class MigrationManager<R extends FactoryBase<?, R>, S> {
    private final Class<R> rootClass;
    private final SimpleObjectMapper objectMapper;
    private final AttributeFiller<R> attributeFiller;
    List<AttributeRename> renameAttributeMigrations = new ArrayList<AttributeRename>();
    List<ClassRename> renameClassMigrations = new ArrayList<ClassRename>();
    List<SingletonDataRestore<R, ?>> singletonBasedRestorations = new ArrayList();
    List<PathDataRestore<R, ?>> pathBasedRestorations = new ArrayList();

    public MigrationManager(Class<R> rootClass, SimpleObjectMapper objectMapper, AttributeFiller<R> attributeFiller) {
        this.rootClass = rootClass;
        this.objectMapper = objectMapper;
        this.attributeFiller = attributeFiller;
    }

    public <L, F extends FactoryBase<L, R>> void renameAttribute(Class<F> dataClass, String previousAttributeName, Function<F, Attribute<?, ?>> attributeNameProvider) {
        this.renameAttributeMigrations.add(new AttributeRename(dataClass, previousAttributeName, attributeNameProvider));
    }

    public void renameClass(String previousDataClassNameFullQualified, Class<? extends FactoryBase<?, ?>> newDataClass) {
        this.renameClassMigrations.add(new ClassRename(previousDataClassNameFullQualified, newDataClass));
    }

    public <V> void restoreAttribute(String singletonPreviousDataClass, String previousAttributeName, Class<V> valueClass, BiConsumer<R, V> setter) {
        this.singletonBasedRestorations.add(new SingletonDataRestore<R, V>(singletonPreviousDataClass, previousAttributeName, valueClass, setter, this.objectMapper));
    }

    public <V> void restoreAttribute(AttributePathTarget<V> path, BiConsumer<R, V> setter) {
        this.pathBasedRestorations.add(new PathDataRestore<R, V>(path, setter, this.objectMapper));
    }

    public R migrate(JsonNode rootNode, DataStorageMetadataDictionary dataStorageMetadataDictionary) {
        FactoryBase root;
        DataJsonNode rootDataJson = new DataJsonNode((ObjectNode)rootNode);
        DataJsonNode previousRootDataJson = new DataJsonNode((ObjectNode)rootNode.deepCopy());
        List<DataJsonNode> dataJsonNodes = rootDataJson.collectChildrenFromRoot();
        for (DataMigration dataMigration : this.renameClassMigrations) {
            if (!dataMigration.canMigrate(dataStorageMetadataDictionary)) continue;
            dataMigration.migrate(dataJsonNodes);
            dataMigration.updateDataStorageMetadataDictionary(dataStorageMetadataDictionary);
        }
        for (DataMigration dataMigration : this.renameAttributeMigrations) {
            if (!dataMigration.canMigrate(dataStorageMetadataDictionary)) continue;
            dataMigration.migrate(dataJsonNodes);
            dataMigration.updateDataStorageMetadataDictionary(dataStorageMetadataDictionary);
        }
        dataStorageMetadataDictionary.markRemovedAttributes();
        try {
            root = (FactoryBase)this.objectMapper.treeToValue(rootNode, this.rootClass);
        }
        catch (RuntimeException runtimeException) {
            if (Throwables.getRootCause((Throwable)runtimeException) instanceof DataObjectIdResolver.UnresolvableJsonIDException) {
                rootDataJson.fixIdsDeepFromRoot(dataStorageMetadataDictionary);
                root = (FactoryBase)this.objectMapper.treeToValue(rootNode, this.rootClass);
            }
            throw runtimeException;
        }
        root.internal().finalise();
        for (SingletonDataRestore<FactoryBase, ?> singletonDataRestore : this.singletonBasedRestorations) {
            if (!singletonDataRestore.canMigrate(dataStorageMetadataDictionary)) continue;
            singletonDataRestore.migrate(dataJsonNodes, root);
        }
        for (PathDataRestore<FactoryBase, ?> pathDataRestore : this.pathBasedRestorations) {
            if (!pathDataRestore.canMigrate(dataStorageMetadataDictionary, rootDataJson)) continue;
            pathDataRestore.migrate(previousRootDataJson, root);
        }
        this.attributeFiller.fillNewAttributes(root, dataStorageMetadataDictionary);
        root.internal().fixDuplicateFactories();
        root.internal().finalise();
        return (R)root;
    }

    public String write(R root) {
        return this.objectMapper.writeValueAsString(root);
    }

    public String writeStorageMetadata(StoredDataMetadata<S> metadata) {
        return this.objectMapper.writeValueAsString(metadata);
    }

    public R read(JsonNode data, DataStorageMetadataDictionary dataStorageMetadataDictionary) {
        return this.read(this.objectMapper.writeTree(data), dataStorageMetadataDictionary);
    }

    public R read(String data, DataStorageMetadataDictionary dataStorageMetadataDictionary) {
        JsonNode migratedData = this.objectMapper.readTree(data);
        return this.migrate(migratedData, dataStorageMetadataDictionary);
    }

    public StoredDataMetadata<S> readStoredFactoryMetadata(String data) {
        return this.objectMapper.readValue(data, StoredDataMetadata.class);
    }

    public ScheduledUpdateMetadata readScheduledFactoryMetadata(String data) {
        return this.objectMapper.readValue(data, ScheduledUpdateMetadata.class);
    }

    public String writeScheduledUpdateMetadata(ScheduledUpdateMetadata metadata) {
        return this.objectMapper.writeValueAsString(metadata);
    }

    public String writeRawFactoryDataAndMetadata(R root, StoredDataMetadata<S> metadata) {
        RawFactoryDataAndMetadata rawFactoryDataAndMetadata = new RawFactoryDataAndMetadata();
        rawFactoryDataAndMetadata.metadata = metadata;
        rawFactoryDataAndMetadata.root = this.objectMapper.writeValueAsTree(root);
        return this.objectMapper.writeValueAsString(rawFactoryDataAndMetadata);
    }

    public RawFactoryDataAndMetadata<S> readRawFactoryDataAndMetadata(String data) {
        return this.objectMapper.readValue(data, RawFactoryDataAndMetadata.class);
    }
}

