/*
 * Decompiled with CFR 0.152.
 */
package io.github.factoryfx.factory.storage.migration.datamigration;

import io.github.factoryfx.factory.FactoryBase;
import io.github.factoryfx.factory.attribute.Attribute;
import io.github.factoryfx.factory.metadata.FactoryMetadataManager;
import io.github.factoryfx.factory.storage.migration.datamigration.DataJsonNode;
import io.github.factoryfx.factory.storage.migration.datamigration.DataMigration;
import io.github.factoryfx.factory.storage.migration.metadata.DataStorageMetadataDictionary;
import java.util.List;
import java.util.function.Function;

public class AttributeRename<R extends FactoryBase<?, R>, L, F extends FactoryBase<L, R>>
implements DataMigration {
    private final String dataClassNameFullQualified;
    private final String previousAttributeName;
    private String newAttributeName;

    public AttributeRename(Class<F> dataClass, String previousAttributeName, Function<F, Attribute<?, ?>> attributeNameProvider) {
        this.dataClassNameFullQualified = dataClass.getName();
        this.previousAttributeName = previousAttributeName;
        F data = FactoryMetadataManager.getMetadata(dataClass).newInstance();
        Attribute<?, ?> newAttribute = attributeNameProvider.apply(data);
        ((FactoryBase)data).internal().visitAttributesFlat((attributeVariableName, attribute) -> {
            if (attribute == newAttribute) {
                this.newAttributeName = attributeVariableName;
            }
        });
        if (this.newAttributeName == null) {
            throw new IllegalArgumentException("wrong attributeNameProvider");
        }
    }

    @Override
    public boolean canMigrate(DataStorageMetadataDictionary dataStorageMetadataDictionary) {
        return dataStorageMetadataDictionary.containsClass(this.dataClassNameFullQualified) && dataStorageMetadataDictionary.containsAttribute(this.dataClassNameFullQualified, this.previousAttributeName);
    }

    @Override
    public void migrate(List<DataJsonNode> dataJsonNodes) {
        dataJsonNodes.stream().filter(dataJsonNode -> dataJsonNode.match(this.dataClassNameFullQualified)).forEach(dataJsonNode -> dataJsonNode.renameAttribute(this.previousAttributeName, this.newAttributeName));
    }

    @Override
    public void updateDataStorageMetadataDictionary(DataStorageMetadataDictionary dataStorageMetadataDictionary) {
        dataStorageMetadataDictionary.renameAttribute(this.dataClassNameFullQualified, this.previousAttributeName, this.newAttributeName);
    }
}

