/*
 * Decompiled with CFR 0.152.
 */
package io.github.factoryfx.factory.storage.migration.datamigration;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.JsonNodeFactory;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.fasterxml.jackson.databind.node.TextNode;
import io.github.factoryfx.factory.FactoryBase;
import io.github.factoryfx.factory.jackson.SimpleObjectMapper;
import io.github.factoryfx.factory.storage.migration.metadata.DataStorageMetadataDictionary;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.function.BiConsumer;
import java.util.function.Consumer;

public class DataJsonNode {
    private final ObjectNode jsonNode;

    public DataJsonNode(ObjectNode jsonNode) {
        this.jsonNode = jsonNode;
    }

    public void removeAttribute(String name) {
        this.jsonNode.remove(name);
    }

    public String getDataClassName() {
        return this.jsonNode.get("@class").textValue();
    }

    public boolean match(String dataClassNameFullQualified) {
        return this.getDataClassName().equals(dataClassNameFullQualified);
    }

    public void renameAttribute(String previousAttributeName, String newAttributeName) {
        this.jsonNode.set(newAttributeName, this.jsonNode.get(previousAttributeName));
        this.jsonNode.remove(previousAttributeName);
    }

    public void renameClass(Class<? extends FactoryBase<?, ?>> newDataClass) {
        this.jsonNode.set("@class", (JsonNode)new TextNode(newDataClass.getName()));
    }

    public DataJsonNode getChild(String attributeName) {
        return new DataJsonNode((ObjectNode)this.jsonNode.get(attributeName).get("v"));
    }

    public DataJsonNode getChild(String attributeName, int index) {
        if (!this.jsonNode.get(attributeName).isArray()) {
            throw new IllegalArgumentException("is not a reflist attribute: " + attributeName);
        }
        return new DataJsonNode((ObjectNode)this.jsonNode.get(attributeName).get(index));
    }

    public JsonNode getAttributeValue(String attribute) {
        if (this.jsonNode.get(attribute) == null) {
            return null;
        }
        if (this.jsonNode.get(attribute).isArray()) {
            return this.jsonNode.get(attribute);
        }
        return this.jsonNode.get(attribute).get("v");
    }

    public void setAttributeValue(String attribute, JsonNode jsonNode) {
        try {
            if (jsonNode == null) {
                ((ObjectNode)this.jsonNode.get(attribute)).remove("v");
            }
            ObjectNode objectNode = JsonNodeFactory.instance.objectNode();
            this.jsonNode.set(attribute, (JsonNode)objectNode);
            objectNode.set("v", jsonNode);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public <V> V getAttributeValue(String attributeName, Class<V> valueClass, SimpleObjectMapper simpleObjectMapper) {
        JsonNode attributeValue = this.getAttributeValue(attributeName);
        if (attributeValue == null) {
            return null;
        }
        return simpleObjectMapper.treeToValue(attributeValue, valueClass);
    }

    public <V> V getArrayAttributeValue(String attributeName, Class<V> valueClass, SimpleObjectMapper simpleObjectMapper, int index) {
        ArrayNode attributeValue = (ArrayNode)this.getAttributeValue(attributeName);
        return simpleObjectMapper.treeToValue(attributeValue.get(index), valueClass);
    }

    public String getAttributeIdValue(String attributeName) {
        return this.jsonNode.get(attributeName).get("v").asText();
    }

    private boolean isData(JsonNode jsonNode) {
        if (jsonNode == null) {
            return false;
        }
        if (jsonNode.fieldNames().hasNext()) {
            String fieldName = (String)jsonNode.fieldNames().next();
            return "@class".equals(fieldName);
        }
        return false;
    }

    public boolean isData() {
        return this.isData((JsonNode)this.jsonNode);
    }

    private void collectChildrenDeep(List<DataJsonNode> dataJsonNodes) {
        for (JsonNode element : this.jsonNode) {
            if (element.isArray()) {
                for (JsonNode arrayElement : element) {
                    if (!this.isData(arrayElement)) continue;
                    DataJsonNode child = new DataJsonNode((ObjectNode)arrayElement);
                    dataJsonNodes.add(child);
                    child.collectChildrenDeep(dataJsonNodes);
                }
                continue;
            }
            if (!this.isData(element.get("v"))) continue;
            DataJsonNode child = new DataJsonNode((ObjectNode)element.get("v"));
            dataJsonNodes.add(child);
            child.collectChildrenDeep(dataJsonNodes);
        }
    }

    public List<DataJsonNode> collectChildrenFromRoot() {
        ArrayList<DataJsonNode> dataJsonNode = new ArrayList<DataJsonNode>();
        dataJsonNode.add(this);
        this.collectChildrenDeep(dataJsonNode);
        return dataJsonNode;
    }

    private void replaceDuplicateFactoriesWidthIdDeep(HashSet<String> collected) {
        this.visitAttributes((value, jsonNodeConsumer) -> {
            if (this.isData((JsonNode)value)) {
                DataJsonNode child = new DataJsonNode((ObjectNode)value);
                if (collected.add(child.getId())) {
                    child.replaceDuplicateFactoriesWidthIdDeep(collected);
                } else {
                    jsonNodeConsumer.accept(new TextNode(child.getId()));
                }
            }
        });
    }

    private void replaceIdRefsWidthFactoriesDeep(Map<String, DataJsonNode> idToDataJsonNode) {
        this.visitAttributes((value, jsonNodeConsumer) -> {
            if (value.isTextual() && idToDataJsonNode.containsKey(value.asText())) {
                jsonNodeConsumer.accept(((DataJsonNode)idToDataJsonNode.get((Object)value.asText())).jsonNode);
            }
            if (this.isData((JsonNode)value)) {
                new DataJsonNode((ObjectNode)value).replaceIdRefsWidthFactoriesDeep(idToDataJsonNode);
            }
        });
    }

    public String getId() {
        return this.jsonNode.get("id").asText();
    }

    public <D> D asData(Class<D> valueClass, SimpleObjectMapper simpleObjectMapper) {
        return simpleObjectMapper.treeToValue((JsonNode)this.jsonNode, valueClass);
    }

    public List<String> getAttributes() {
        ArrayList<String> result = new ArrayList<String>();
        Iterator field = this.jsonNode.fields();
        while (field.hasNext()) {
            Map.Entry element = (Map.Entry)field.next();
            if (((JsonNode)element.getValue()).isObject()) {
                result.add((String)element.getKey());
            }
            if (!((JsonNode)element.getValue()).isArray()) continue;
            result.add((String)element.getKey());
        }
        return result;
    }

    public Map<String, DataJsonNode> collectChildrenMapFromRoot() {
        HashMap<String, DataJsonNode> result = new HashMap<String, DataJsonNode>();
        for (DataJsonNode dataJsonNode : this.collectChildrenFromRoot()) {
            result.put(dataJsonNode.getId(), dataJsonNode);
        }
        return result;
    }

    public void applyRemovedAttribute(DataStorageMetadataDictionary dataStorageMetadataDictionary) {
        for (String attributeVariableName : this.getAttributes()) {
            if (!dataStorageMetadataDictionary.isRemovedAttribute(this.getDataClassName(), attributeVariableName)) continue;
            this.jsonNode.remove(attributeVariableName);
        }
    }

    public void fixIdsDeepFromRoot(DataStorageMetadataDictionary dataStorageMetadataDictionary) {
        this.replaceIdRefsWidthFactoriesDeep(this.collectChildrenMapFromRoot());
        for (DataJsonNode dataJsonNode : this.collectChildrenFromRoot()) {
            dataJsonNode.applyRemovedAttribute(dataStorageMetadataDictionary);
        }
        this.replaceDuplicateFactoriesWidthIdDeep(new HashSet<String>());
    }

    private void visitAttributes(BiConsumer<JsonNode, Consumer<JsonNode>> attributeConsumer) {
        for (String attributeVariableName : this.getAttributes()) {
            JsonNode attributeValue = this.getAttributeValue(attributeVariableName);
            if (attributeValue == null) continue;
            if (attributeValue.isArray()) {
                int index = 0;
                for (JsonNode arrayElement : attributeValue) {
                    int setIndex = index++;
                    attributeConsumer.accept(arrayElement, value -> ((ArrayNode)attributeValue).set(setIndex, value));
                }
                continue;
            }
            attributeConsumer.accept(attributeValue, value -> this.setAttributeValue(attributeVariableName, (JsonNode)value));
        }
    }

    public JsonNode getJsonNode() {
        return this.jsonNode;
    }
}

