/*
 * Decompiled with CFR 0.152.
 */
package io.github.factoryfx.factory.storage.migration.datamigration;

import io.github.factoryfx.factory.storage.migration.datamigration.AttributePathElement;
import io.github.factoryfx.factory.storage.migration.datamigration.AttributePathTarget;
import io.github.factoryfx.factory.storage.migration.datamigration.RefAttributePathElement;
import io.github.factoryfx.factory.storage.migration.datamigration.RefListAttributePathElement;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class PathBuilder<V> {
    private Class<V> valueClass;
    private final List<AttributePathElement> path = new ArrayList<AttributePathElement>();

    public PathBuilder(Class<V> valueClass) {
        this.valueClass = valueClass;
    }

    public static <V> PathBuilder<V> value(Class<V> valueClass) {
        return new PathBuilder<V>(valueClass);
    }

    public PathBuilder<V> pathElement(String pathElement) {
        this.path.add(new RefAttributePathElement(pathElement));
        return this;
    }

    public PathBuilder<V> pathElement(String pathElement, int index) {
        this.path.add(new RefListAttributePathElement(pathElement, index));
        return this;
    }

    public AttributePathTarget<V> attribute(String attribute) {
        return new AttributePathTarget<V>(this.valueClass, this.path, attribute, 0);
    }

    public AttributePathTarget<V> attribute(String attribute, int index) {
        return new AttributePathTarget<V>(this.valueClass, this.path, attribute, index);
    }

    public static <V> AttributePathTarget<V> of(Class<V> valueClass, String path) {
        Pattern pattern = Pattern.compile("([[a-zA-Z_$]]*)\\[(\\d+)]");
        ArrayList<AttributePathElement> pathList = new ArrayList<AttributePathElement>();
        String[] split = path.split("\\.");
        String attributeName = split[split.length - 1];
        int attributeNameIndex = 0;
        Matcher attributeIndexMatcher = pattern.matcher(attributeName);
        if (attributeIndexMatcher.matches()) {
            attributeName = attributeIndexMatcher.group(1);
            attributeNameIndex = Integer.parseInt(attributeIndexMatcher.group(2));
        }
        for (String pathElement : Arrays.asList(split).subList(0, split.length - 1)) {
            Matcher matcher = pattern.matcher(pathElement);
            if (matcher.matches()) {
                pathList.add(new RefListAttributePathElement(matcher.group(1), Integer.parseInt(matcher.group(2))));
                continue;
            }
            pathList.add(new RefAttributePathElement(pathElement));
        }
        return new AttributePathTarget<V>(valueClass, pathList, attributeName, attributeNameIndex);
    }
}

