/*
 * Decompiled with CFR 0.152.
 */
package io.github.factoryfx.factory.storage.migration.datamigration;

import io.github.factoryfx.factory.FactoryBase;
import io.github.factoryfx.factory.jackson.SimpleObjectMapper;
import io.github.factoryfx.factory.storage.migration.datamigration.DataJsonNode;
import io.github.factoryfx.factory.storage.migration.metadata.DataStorageMetadataDictionary;
import java.util.List;
import java.util.function.BiConsumer;

public class SingletonDataRestore<R extends FactoryBase<?, ?>, V> {
    private final String previousAttributeName;
    private String singletonPreviousDataClass;
    private final BiConsumer<R, V> setter;
    private final Class<V> valueClass;
    private final SimpleObjectMapper simpleObjectMapper;

    public SingletonDataRestore(String singletonPreviousDataClass, String previousAttributeName, Class<V> valueClass, BiConsumer<R, V> setter, SimpleObjectMapper simpleObjectMapper) {
        this.previousAttributeName = previousAttributeName;
        this.singletonPreviousDataClass = singletonPreviousDataClass;
        this.setter = setter;
        this.valueClass = valueClass;
        this.simpleObjectMapper = simpleObjectMapper;
    }

    public boolean canMigrate(DataStorageMetadataDictionary previousDataStorageMetadataDictionary) {
        return previousDataStorageMetadataDictionary.isRemovedAttribute(this.singletonPreviousDataClass, this.previousAttributeName) && previousDataStorageMetadataDictionary.isSingleton(this.singletonPreviousDataClass) && previousDataStorageMetadataDictionary.containsClass(this.singletonPreviousDataClass) && previousDataStorageMetadataDictionary.containsAttribute(this.singletonPreviousDataClass, this.previousAttributeName);
    }

    public void migrate(List<DataJsonNode> dataJsonNodes, R root) {
        DataJsonNode previousData = dataJsonNodes.stream().filter(dataJsonNode -> dataJsonNode.match(this.singletonPreviousDataClass)).findFirst().get();
        V attributeValue = previousData.getAttributeValue(this.previousAttributeName, this.valueClass, this.simpleObjectMapper);
        this.setter.accept(root, attributeValue);
    }
}

