/*
 * Decompiled with CFR 0.152.
 */
package io.github.factoryfx.factory.storage.migration.metadata;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;

public class AttributeStorageMetadata {
    @JsonProperty
    String variableName;
    @JsonProperty
    final String attributeClassName;
    @JsonProperty
    final boolean isReference;
    @JsonProperty
    String referenceClass;
    private boolean removed;

    @JsonCreator
    public AttributeStorageMetadata(@JsonProperty(value="variableName") String variableName, @JsonProperty(value="attributeClassName") String attributeClassName, @JsonProperty(value="isReference") boolean isReference, @JsonProperty(value="referenceClass") String referenceClass) {
        this.variableName = variableName;
        this.attributeClassName = attributeClassName;
        this.isReference = isReference;
        this.referenceClass = referenceClass;
    }

    public String getVariableName() {
        return this.variableName;
    }

    public boolean match(AttributeStorageMetadata attributeStorageMetadata) {
        return this.variableName.equals(attributeStorageMetadata.variableName) && this.attributeClassName.equals(attributeStorageMetadata.attributeClassName);
    }

    public void rename(String newAttributeName) {
        this.variableName = newAttributeName;
    }

    @JsonIgnore
    public boolean isReference() {
        return this.isReference;
    }

    public void markRemoved() {
        this.removed = true;
    }

    public boolean isRemoved() {
        return this.removed;
    }

    public String getReferenceClass() {
        return this.referenceClass;
    }

    public void renameReferenceClass(String previousDataClassNameFullQualified, String newNameFullQualified) {
        if (previousDataClassNameFullQualified.equals(this.referenceClass)) {
            this.referenceClass = newNameFullQualified;
        }
    }
}

