/*
 * Decompiled with CFR 0.152.
 */
package io.github.factoryfx.factory.storage.migration.metadata;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.github.factoryfx.factory.FactoryBase;
import io.github.factoryfx.factory.metadata.FactoryMetadataManager;
import io.github.factoryfx.factory.storage.migration.metadata.AttributeStorageMetadata;
import io.github.factoryfx.factory.storage.migration.metadata.DataStorageMetadataDictionary;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;

public class DataStorageMetadata {
    @JsonProperty
    private String className;
    @JsonProperty
    private final List<AttributeStorageMetadata> attributes;
    @JsonProperty
    private final long count;
    private Map<String, AttributeStorageMetadata> nameToAttributeMap;

    @JsonCreator
    public DataStorageMetadata(@JsonProperty(value="attributes") List<AttributeStorageMetadata> attributes, @JsonProperty(value="className") String className, @JsonProperty(value="count") long count) {
        this.attributes = attributes;
        this.className = className;
        this.count = count;
    }

    public AttributeStorageMetadata getAttribute(String attributeName) {
        if (this.nameToAttributeMap == null) {
            this.nameToAttributeMap = new HashMap<String, AttributeStorageMetadata>();
            for (AttributeStorageMetadata attribute : this.attributes) {
                this.nameToAttributeMap.put(attribute.getVariableName(), attribute);
            }
        }
        return this.nameToAttributeMap.get(attributeName);
    }

    public String getClassName() {
        return this.className;
    }

    public boolean match(DataStorageMetadata dataStorageMetadata) {
        if (!this.className.equals(dataStorageMetadata.className)) {
            return false;
        }
        if (this.attributes.size() != dataStorageMetadata.attributes.size()) {
            return false;
        }
        for (int i = 0; i < this.attributes.size(); ++i) {
            if (this.attributes.get(i).match(dataStorageMetadata.attributes.get(i))) continue;
            return false;
        }
        return true;
    }

    public boolean containsAttribute(String attributeName) {
        AttributeStorageMetadata attribute = this.getAttribute(attributeName);
        return attribute != null;
    }

    public boolean isRemovedAttribute(String attributeName) {
        AttributeStorageMetadata attribute = this.getAttribute(attributeName);
        if (attribute != null) {
            return attribute.isRemoved();
        }
        return false;
    }

    public boolean isSingleton() {
        return this.count == 1L;
    }

    public void renameAttribute(String previousAttributeName, String newAttributeName) {
        AttributeStorageMetadata attribute = this.getAttribute(previousAttributeName);
        if (attribute == null) {
            throw new IllegalArgumentException("attribute not found: " + previousAttributeName);
        }
        attribute.rename(newAttributeName);
        this.nameToAttributeMap = null;
    }

    public void removeAttribute(String attributeName) {
        AttributeStorageMetadata attribute = this.getAttribute(attributeName);
        if (attribute != null) {
            this.attributes.remove(attribute);
            this.nameToAttributeMap = null;
        }
    }

    public void renameClass(String previousDataClassNameFullQualified, String newNameFullQualified) {
        if (previousDataClassNameFullQualified.equals(this.className)) {
            this.className = newNameFullQualified;
        }
        for (AttributeStorageMetadata attribute : this.attributes) {
            attribute.renameReferenceClass(previousDataClassNameFullQualified, newNameFullQualified);
        }
    }

    public void markRemovedAttributes() {
        try {
            Class<?> aClass = Class.forName(this.className);
            Object data = FactoryMetadataManager.getMetadata(aClass).newInstance();
            HashSet currentAttributeVariableNames = new HashSet();
            ((FactoryBase)data).internal().visitAttributesFlat((attributeVariableName, attribute) -> currentAttributeVariableNames.add(attributeVariableName));
            for (AttributeStorageMetadata attribute2 : this.attributes) {
                if (currentAttributeVariableNames.contains(attribute2.getVariableName())) continue;
                attribute2.markRemoved();
            }
        }
        catch (ClassNotFoundException e) {
            for (AttributeStorageMetadata attribute3 : this.attributes) {
                attribute3.markRemoved();
            }
        }
    }

    public boolean isReferenceAttribute(String attributeName) {
        AttributeStorageMetadata attribute = this.getAttribute(attributeName);
        if (attribute != null) {
            return attribute.isReference();
        }
        return false;
    }

    public DataStorageMetadata getChild(String attribute, DataStorageMetadataDictionary dictionary) {
        return dictionary.getDataStorageMetadata(this.getAttribute(attribute).getReferenceClass());
    }
}

