/*
 * Decompiled with CFR 0.152.
 */
package io.github.factoryfx.factory.storage.migration.metadata;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.github.factoryfx.factory.storage.migration.metadata.DataStorageMetadata;
import java.util.List;

public class DataStorageMetadataDictionary {
    @JsonProperty
    final List<DataStorageMetadata> dataList;
    @JsonProperty
    String rootClass;

    @JsonCreator
    public DataStorageMetadataDictionary(@JsonProperty(value="dataList") List<DataStorageMetadata> dataList, @JsonProperty(value="rootClass") String rootClass) {
        this.dataList = dataList;
        this.rootClass = rootClass;
    }

    public DataStorageMetadata getDataStorageMetadata(String dataClassNameFullQualified) {
        for (DataStorageMetadata dataStorageMetadata : this.dataList) {
            if (!dataStorageMetadata.getClassName().equals(dataClassNameFullQualified)) continue;
            return dataStorageMetadata;
        }
        return null;
    }

    public boolean containsClass(String dataClassNameFullQualified) {
        return this.getDataStorageMetadata(dataClassNameFullQualified) != null;
    }

    public boolean containsAttribute(String dataClassNameFullQualified, String previousAttributeName) {
        DataStorageMetadata dataStorageMetadata = this.getDataStorageMetadata(dataClassNameFullQualified);
        if (dataStorageMetadata != null) {
            return dataStorageMetadata.containsAttribute(previousAttributeName);
        }
        return false;
    }

    public boolean isSingleton(String fullQualifiedName) {
        DataStorageMetadata dataStorageMetadata = this.getDataStorageMetadata(fullQualifiedName);
        if (dataStorageMetadata != null) {
            return dataStorageMetadata.isSingleton();
        }
        return false;
    }

    public void renameAttribute(String dataClassNameFullQualified, String previousAttributeName, String newAttributeName) {
        for (DataStorageMetadata dataStorageMetadata : this.dataList) {
            if (!dataStorageMetadata.getClassName().equals(dataClassNameFullQualified)) continue;
            dataStorageMetadata.renameAttribute(previousAttributeName, newAttributeName);
            return;
        }
        throw new IllegalArgumentException("factory not found: " + dataClassNameFullQualified);
    }

    public void renameClass(String previousDataClassNameFullQualified, String newNameFullQualified) {
        for (DataStorageMetadata dataStorageMetadata : this.dataList) {
            dataStorageMetadata.renameClass(previousDataClassNameFullQualified, newNameFullQualified);
        }
        if (previousDataClassNameFullQualified.equals(this.rootClass)) {
            this.rootClass = newNameFullQualified;
        }
    }

    public boolean isRemovedAttribute(String dataClass, String previousAttributeName) {
        DataStorageMetadata dataStorageMetadata = this.getDataStorageMetadata(dataClass);
        if (dataStorageMetadata != null) {
            return dataStorageMetadata.isRemovedAttribute(previousAttributeName);
        }
        return false;
    }

    public void markRemovedAttributes() {
        this.dataList.forEach(DataStorageMetadata::markRemovedAttributes);
    }

    public boolean isReferenceAttribute(String dataClass, String attributeName) {
        DataStorageMetadata dataStorageMetadata = this.getDataStorageMetadata(dataClass);
        if (dataStorageMetadata != null) {
            return dataStorageMetadata.isReferenceAttribute(attributeName);
        }
        return false;
    }

    public DataStorageMetadata getRootDataStorageMetadata() {
        return this.getDataStorageMetadata(this.rootClass);
    }
}

