/*
 * Decompiled with CFR 0.152.
 */
package io.github.factoryfx.factory.util;

import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;

public class LanguageText {
    @JsonProperty
    private Map<Locale, String> texts = new HashMap<Locale, String>();

    public LanguageText() {
    }

    public LanguageText(String englishText) {
        this.en(englishText);
    }

    public LanguageText en(String text) {
        this.internal_put(Locale.ENGLISH, text);
        return this;
    }

    public LanguageText de(String text) {
        this.internal_put(Locale.GERMAN, text);
        return this;
    }

    public LanguageText es(String text) {
        this.internal_put(new Locale("es", "ES"), text);
        return this;
    }

    public LanguageText fr(String text) {
        this.internal_put(Locale.FRANCE, text);
        return this;
    }

    public LanguageText it(String text) {
        this.internal_put(Locale.ITALIAN, text);
        return this;
    }

    public LanguageText pt(String text) {
        this.internal_put(new Locale("pt", "PT"), text);
        return this;
    }

    public void internal_set(LanguageText languageText) {
        this.texts = new HashMap<Locale, String>(languageText.texts);
    }

    public String internal_getText(Locale locale) {
        return this.texts.get(locale);
    }

    public String internal_getPreferred(Locale locale) {
        String text = this.texts.get(locale);
        if (text == null) {
            if (this.texts.isEmpty()) {
                return "";
            }
            return this.texts.entrySet().iterator().next().getValue();
        }
        return text;
    }

    public LanguageText internal_put(Locale locale, String text) {
        this.texts.put(locale, text);
        return this;
    }

    public String toString() {
        StringBuilder result = new StringBuilder();
        for (Map.Entry<Locale, String> entry : this.texts.entrySet()) {
            result.append(entry.getKey());
            result.append(":");
            result.append(entry.getValue());
            result.append(", ");
        }
        return result.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        LanguageText that = (LanguageText)o;
        return Objects.equals(this.texts, that.texts);
    }

    public int hashCode() {
        return Objects.hash(this.texts);
    }
}

