/*
 * Decompiled with CFR 0.152.
 */
package io.github.factoryfx.factory.validation;

import io.github.factoryfx.factory.FactoryBase;
import io.github.factoryfx.factory.attribute.Attribute;
import io.github.factoryfx.factory.validation.Validation;
import io.github.factoryfx.factory.validation.ValidationError;
import io.github.factoryfx.factory.validation.ValidationResult;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class AttributeValidation<T> {
    private final Validation<T> validation;
    private final Attribute[] dependencies;

    public AttributeValidation(Validation<T> validation, Attribute<?, ?> ... dependencies) {
        this.validation = validation;
        this.dependencies = dependencies;
    }

    public Map<Attribute<?, ?>, List<ValidationError>> validate(FactoryBase<?, ?> data) {
        ValidationResult validationResult = this.validation.validate(data);
        if (validationResult.validationFailed()) {
            HashMap result = new HashMap();
            for (Attribute dependency : this.dependencies) {
                List validationErrors = result.computeIfAbsent(dependency, k -> new ArrayList());
                validationErrors.add(validationResult.createValidationError(dependency, data, ""));
            }
            return result;
        }
        return new HashMap();
    }
}

