/*
 * Decompiled with CFR 0.152.
 */
package io.github.factoryfx.factory.validation;

import io.github.factoryfx.factory.util.LanguageText;
import io.github.factoryfx.factory.validation.Validation;
import io.github.factoryfx.factory.validation.ValidationResult;
import java.util.List;

public class MinimumOccurrence<T, R extends List<T>>
implements Validation<R> {
    private final int minimalOccurrence;

    public MinimumOccurrence(int minimalOccurrence) {
        this.minimalOccurrence = minimalOccurrence;
    }

    @Override
    public ValidationResult validate(R value) {
        boolean error = false;
        if (value != null) {
            error = value.size() < this.minimalOccurrence;
        }
        return new ValidationResult(error, new LanguageText().en("at least " + this.minimalOccurrence + " item(s) required").de("Mindestens " + this.minimalOccurrence + " erforderlich"));
    }
}

