/*
 * Decompiled with CFR 0.152.
 */
package io.github.factoryfx.factory.validation;

import io.github.factoryfx.factory.util.LanguageText;
import io.github.factoryfx.factory.validation.Validation;
import io.github.factoryfx.factory.validation.ValidationResult;
import java.util.Optional;
import java.util.regex.Pattern;

public class RegexValidation
implements Validation<String> {
    private final Pattern pattern;

    public RegexValidation(Pattern pattern) {
        this.pattern = pattern;
    }

    @Override
    public ValidationResult validate(String value) {
        boolean error = Optional.ofNullable(value).map(ss -> this.pattern.matcher((CharSequence)ss).matches()).orElse(true);
        return new ValidationResult(!error, new LanguageText().en("Input match pattern '" + this.pattern.pattern() + "'"));
    }
}

