/*
 * Decompiled with CFR 0.152.
 */
package io.github.factoryfx.factory.validation;

import io.github.factoryfx.factory.util.LanguageText;
import io.github.factoryfx.factory.validation.Validation;
import io.github.factoryfx.factory.validation.ValidationResult;
import java.util.HashSet;
import java.util.List;
import java.util.function.Function;

public class UniqueListBy<T, V>
implements Validation<List<T>> {
    private final Function<T, V> mapper;

    public UniqueListBy(Function<T, V> mapper) {
        this.mapper = mapper;
    }

    @Override
    public ValidationResult validate(List<T> list) {
        boolean error = false;
        HashSet<V> set = new HashSet<V>();
        for (T item : list) {
            if (set.add(this.mapper.apply(item))) continue;
            error = true;
        }
        return new ValidationResult(error, new LanguageText().en("List contains duplicate entries").de("Liste enth\u00e4lt doppelte Eintr\u00e4ge"));
    }
}

