/*
 * Decompiled with CFR 0.152.
 */
package io.github.factoryfx.factory.validation;

import io.github.factoryfx.factory.FactoryBase;
import io.github.factoryfx.factory.attribute.Attribute;
import io.github.factoryfx.factory.util.LanguageText;
import java.util.Locale;
import java.util.function.Function;

public class ValidationError {
    private final LanguageText validationDescription;
    private final Attribute<?, ?> attribute;
    private final FactoryBase<?, ?> parent;
    private final String attributeVariableName;

    public ValidationError(LanguageText validationDescription, Attribute<?, ?> attribute, FactoryBase<?, ?> parent, String attributeVariableName) {
        this.validationDescription = validationDescription;
        this.attribute = attribute;
        this.parent = parent;
        this.attributeVariableName = attributeVariableName;
    }

    public String validationDescription(Function<LanguageText, String> languageTextEvaluator) {
        return languageTextEvaluator.apply(this.validationDescription);
    }

    public String attributeDescription(Locale locale) {
        String label = this.attribute.internal_getPreferredLabelText(locale);
        if (label.isEmpty()) {
            label = this.attributeVariableName;
        }
        return label;
    }

    public String getSimpleErrorDescription() {
        return "        Factory class: " + this.parent.getClass().getName() + "\n        Attribute: " + this.attributeVariableName + " (label: " + this.attribute.internal_getPreferredLabelText(Locale.ENGLISH) + ")\n        Error: " + this.validationDescription.internal_getPreferred(Locale.ENGLISH);
    }
}

