/*
 * Decompiled with CFR 0.152.
 */
package io.github.factoryfx.factory.validator;

import io.github.factoryfx.factory.FactoryBase;
import io.github.factoryfx.factory.metadata.FactoryMetadataManager;
import io.github.factoryfx.factory.validator.FactoryStyleValidation;
import io.github.factoryfx.factory.validator.FinalValidation;
import io.github.factoryfx.factory.validator.NoIdAsAttributeName;
import io.github.factoryfx.factory.validator.NotInnerClassValidation;
import io.github.factoryfx.factory.validator.NotNullAttributeValidation;
import io.github.factoryfx.factory.validator.OnlyAttribute;
import io.github.factoryfx.factory.validator.PublicValidation;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.function.Function;

public class FactoryStyleValidatorBuilder {
    private final Function<FactoryValidatorUtility, List<FactoryStyleValidation>> fieldValidationAdder;
    private final Function<FactoryValidatorUtility, List<FactoryStyleValidation>> classValidationAdder;

    public FactoryStyleValidatorBuilder(Function<FactoryValidatorUtility, List<FactoryStyleValidation>> validationAdder, Function<FactoryValidatorUtility, List<FactoryStyleValidation>> classValidationAdder) {
        this.fieldValidationAdder = validationAdder;
        this.classValidationAdder = classValidationAdder;
    }

    public FactoryStyleValidatorBuilder() {
        this(factoryValidatorUtility -> {
            ArrayList<FactoryStyleValidation> factoryStyleValidations = new ArrayList<FactoryStyleValidation>();
            factoryStyleValidations.add(new OnlyAttribute(factoryValidatorUtility.getFactoryClass(), factoryValidatorUtility.getField()));
            factoryStyleValidations.add(new NotNullAttributeValidation(factoryValidatorUtility::create, factoryValidatorUtility.getField()));
            factoryStyleValidations.add(new PublicValidation(factoryValidatorUtility.getFactoryClass(), factoryValidatorUtility.getField()));
            factoryStyleValidations.add(new FinalValidation(factoryValidatorUtility.getFactoryClass(), factoryValidatorUtility.getField()));
            factoryStyleValidations.add(new NoIdAsAttributeName(factoryValidatorUtility.getField()));
            return factoryStyleValidations;
        }, factoryValidatorUtility -> List.of(new NotInnerClassValidation(factoryValidatorUtility.getFactoryClass())));
    }

    public List<FactoryStyleValidation> createFactoryValidations(Class<? extends FactoryBase<?, ?>> factoryClass) {
        ArrayList<FactoryStyleValidation> result = new ArrayList<FactoryStyleValidation>((Collection)this.classValidationAdder.apply(new FactoryValidatorUtility(factoryClass, null)));
        for (Field field : factoryClass.getDeclaredFields()) {
            if (field.getName().equals("$assertionsDisabled") || field.getName().equals("$jacocoData")) continue;
            result.addAll((Collection<FactoryStyleValidation>)this.fieldValidationAdder.apply(new FactoryValidatorUtility(factoryClass, field)));
        }
        return result;
    }

    private static class FactoryValidatorUtility {
        private final Class<? extends FactoryBase<?, ?>> factoryClass;
        private final Field field;

        public FactoryValidatorUtility(Class<? extends FactoryBase<?, ?>> factoryClass, Field field) {
            this.factoryClass = factoryClass;
            this.field = field;
        }

        public FactoryBase<?, ?> create() {
            return FactoryMetadataManager.getMetadataUnsafe(this.factoryClass).newInstance();
        }

        public Field getField() {
            return this.field;
        }

        public Class<? extends FactoryBase<?, ?>> getFactoryClass() {
            return this.factoryClass;
        }
    }
}

