/*
 * Decompiled with CFR 0.152.
 */
package io.github.factoryfx.factory.validator;

import io.github.factoryfx.factory.FactoryBase;
import io.github.factoryfx.factory.validator.FactoryStyleValidation;
import java.lang.reflect.Field;
import java.util.Optional;
import java.util.function.Supplier;

public class NotNullAttributeValidation
implements FactoryStyleValidation {
    private final Supplier<? extends FactoryBase<?, ?>> factoryBaseSupplier;
    private final Field attributeField;

    public NotNullAttributeValidation(Supplier<? extends FactoryBase<?, ?>> factoryBaseSupplier, Field attributeField) {
        this.factoryBaseSupplier = factoryBaseSupplier;
        this.attributeField = attributeField;
    }

    @Override
    public Optional<String> validateFactory() {
        try {
            FactoryBase<?, ?> factoryBase = this.factoryBaseSupplier.get();
            if (this.attributeField.get(factoryBase) == null) {
                return Optional.of("should be not null: " + factoryBase.getClass().getName() + "#" + this.attributeField.getName());
            }
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
        return Optional.empty();
    }
}

