/*
 * Decompiled with CFR 0.152.
 */
package io.github.factoryfx.server;

import io.github.factoryfx.factory.FactoryBase;
import io.github.factoryfx.factory.FactoryManager;
import io.github.factoryfx.factory.RootFactoryWrapper;
import io.github.factoryfx.factory.builder.FactoryTreeBuilder;
import io.github.factoryfx.factory.log.FactoryUpdateLog;
import io.github.factoryfx.factory.merge.DataMerger;
import io.github.factoryfx.factory.merge.MergeDiffInfo;
import io.github.factoryfx.factory.storage.ChangeSummaryCreator;
import io.github.factoryfx.factory.storage.DataAndId;
import io.github.factoryfx.factory.storage.DataStorage;
import io.github.factoryfx.factory.storage.DataUpdate;
import io.github.factoryfx.factory.storage.StoredDataMetadata;
import java.util.Collection;

public class Microservice<L, R extends FactoryBase<L, R>, S> {
    private final FactoryManager<L, R> factoryManager;
    private final DataStorage<R, S> dataStorage;
    private final ChangeSummaryCreator<R, S> changeSummaryCreator;
    private final FactoryTreeBuilder<L, R, S> factoryTreeBuilder;

    public Microservice(FactoryManager<L, R> factoryManager, DataStorage<R, S> dataStorage, ChangeSummaryCreator<R, S> changeSummaryCreator, FactoryTreeBuilder<L, R, S> factoryTreeBuilder) {
        this.factoryManager = factoryManager;
        this.dataStorage = dataStorage;
        this.changeSummaryCreator = changeSummaryCreator;
        this.factoryTreeBuilder = factoryTreeBuilder;
    }

    public MergeDiffInfo<R> getDiffToPreviousVersion(StoredDataMetadata<S> storedDataMetadata) {
        R historyCurrent = this.getHistoryFactory(storedDataMetadata.mergerVersionId);
        R historyCommon = this.getHistoryFactory(storedDataMetadata.baseVersionId);
        R historyUpdate = this.getHistoryFactory(storedDataMetadata.id);
        return new DataMerger<R>(historyCurrent, historyCommon, historyUpdate).createMergeResult(permission -> true).executeMerge();
    }

    public FactoryUpdateLog<R> revertTo(StoredDataMetadata<S> storedDataMetadata, String user) {
        R historyFactory = this.getHistoryFactory(storedDataMetadata.id);
        DataAndId<R> currentFactory = this.dataStorage.getCurrentData();
        return this.updateCurrentFactory(new DataUpdate<R>(historyFactory, user, "revert to: " + storedDataMetadata.id, currentFactory.id));
    }

    public FactoryUpdateLog<R> updateCurrentFactory(DataUpdate<R> update) {
        R commonVersion = this.dataStorage.getHistoryData(update.baseVersionId);
        FactoryUpdateLog<R> factoryLog = this.factoryManager.update(commonVersion, update.root, update.permissionChecker);
        if (!factoryLog.failedUpdate() && factoryLog.successfullyMerged()) {
            Object changeSummary = null;
            if (factoryLog.mergeDiffInfo != null && this.changeSummaryCreator != null) {
                changeSummary = this.changeSummaryCreator.createChangeSummary(factoryLog.mergeDiffInfo);
            }
            Object copy = ((FactoryBase)this.factoryManager.getCurrentFactory()).utility().copy();
            DataUpdate updateAfterMerge = new DataUpdate(copy, update.user, update.comment, update.baseVersionId);
            this.dataStorage.updateCurrentData(updateAfterMerge, changeSummary);
        }
        return factoryLog;
    }

    public MergeDiffInfo<R> simulateUpdateCurrentFactory(DataUpdate<R> possibleUpdate) {
        R commonVersion = this.dataStorage.getHistoryData(possibleUpdate.baseVersionId);
        return this.factoryManager.simulateUpdate(commonVersion, possibleUpdate.root, possibleUpdate.permissionChecker);
    }

    public DataUpdate<R> prepareNewFactory() {
        if (!this.factoryManager.isStarted()) {
            throw new IllegalStateException("Microservice is not started");
        }
        return this.prepareNewFactory("", "");
    }

    public DataUpdate<R> prepareNewFactory(String user, String comment) {
        DataAndId<R> currentFactory = this.dataStorage.getCurrentData();
        return new DataUpdate(((FactoryBase)this.factoryManager.getCurrentFactory()).utility().copy(), user, comment, currentFactory.id);
    }

    public R getHistoryFactory(String id) {
        return this.dataStorage.getHistoryData(id);
    }

    public Collection<StoredDataMetadata<S>> getHistoryFactoryList() {
        return this.dataStorage.getHistoryDataList();
    }

    public L start() {
        DataAndId<R> currentFactory = this.dataStorage.getCurrentData();
        ((FactoryBase)currentFactory.root).internal().setMicroservice(this);
        ((FactoryBase)currentFactory.root).internal().setFactoryTreeBuilder(this.factoryTreeBuilder);
        return this.factoryManager.start(new RootFactoryWrapper(currentFactory.root));
    }

    public void stop() {
        this.factoryManager.stop();
    }

    public L getRootLiveObject() {
        return ((FactoryBase)this.factoryManager.getCurrentFactory()).internal().getLiveObject();
    }
}

