/*
 * Decompiled with CFR 0.152.
 */
package io.github.factoryfx.server.user;

import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Locale;
import java.util.Set;

public class AuthorizedUser {
    private final String user;
    private final Locale locale;
    private final Collection<String> permissions;

    public AuthorizedUser(String user, Locale locale, Set<String> permissions) {
        this.user = user;
        this.locale = locale;
        this.permissions = permissions;
    }

    public AuthorizedUser(String user, Locale locale, String ... permissions) {
        this.user = user;
        this.locale = locale;
        this.permissions = new HashSet<String>();
        this.permissions.addAll(Arrays.asList(permissions));
    }

    public void checkPermission(String permission) {
        if (permission != null && !this.permissions.contains(permission)) {
            throw new IllegalStateException("permission required: " + permission);
        }
    }

    public boolean checkPermissionValid(String permission) {
        return permission == null || this.permissions.contains(permission);
    }

    public Locale getLocale() {
        return this.locale;
    }

    public String getUserName() {
        return this.user;
    }
}

