/*
 * Decompiled with CFR 0.152.
 */
package io.github.factoryfx.server.user.persistent;

import io.github.factoryfx.server.user.AuthorizedUser;
import io.github.factoryfx.server.user.User;
import io.github.factoryfx.server.user.UserManagement;
import java.util.List;
import java.util.Optional;

public class PersistentUserManagement
implements UserManagement {
    private final List<User> users;

    public PersistentUserManagement(List<User> users) {
        this.users = users;
    }

    @Override
    public Optional<AuthorizedUser> authenticate(String user, String password) {
        for (User existingUser : this.users) {
            if (!existingUser.matchUser(user, password)) continue;
            return Optional.of(existingUser.toAuthorizedUser());
        }
        return Optional.empty();
    }

    @Override
    public boolean authorisationRequired() {
        return true;
    }
}

