/*
 * Decompiled with CFR 0.152.
 */
package io.github.factoryfx.server.user.persistent;

import io.github.factoryfx.factory.FactoryBase;
import io.github.factoryfx.factory.PolymorphicFactoryBase;
import io.github.factoryfx.factory.attribute.dependency.FactoryListAttribute;
import io.github.factoryfx.factory.util.LanguageText;
import io.github.factoryfx.factory.validation.ValidationResult;
import io.github.factoryfx.server.user.User;
import io.github.factoryfx.server.user.UserManagement;
import io.github.factoryfx.server.user.persistent.PersistentUserManagement;
import io.github.factoryfx.server.user.persistent.UserFactory;
import java.util.HashSet;

public class PersistentUserManagementFactory<R extends FactoryBase<?, R>>
extends PolymorphicFactoryBase<UserManagement, R> {
    public final FactoryListAttribute<R, User, UserFactory<R>> users = (FactoryListAttribute)((FactoryListAttribute)((FactoryListAttribute)new FactoryListAttribute().en("users")).de("Benutzer")).userNotSelectable();

    @Override
    protected PersistentUserManagement createImpl() {
        return new PersistentUserManagement(this.users.instances());
    }

    public PersistentUserManagementFactory() {
        this.config().setDisplayTextProvider(() -> "user management");
        this.users.validation(value -> {
            HashSet<String> set = new HashSet<String>();
            LanguageText en = new LanguageText().en("user name is not unique");
            for (UserFactory user : this.users) {
                if (set.add((String)user.name.get())) continue;
                return new ValidationResult(true, en);
            }
            return new ValidationResult(false, en);
        });
    }

    @Override
    public Class<UserManagement> getLiveObjectClass() {
        return UserManagement.class;
    }
}

