/*
 * Decompiled with CFR 0.152.
 */
package io.github.factoryfx.soap;

import java.lang.reflect.Method;
import java.util.HashSet;
import java.util.Set;
import javax.jws.WebService;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.annotation.XmlRootElement;

public class JAXBSoapUtil {
    private static boolean hasWebServiceAnnotation(Class<?> clazz) {
        while (clazz != null) {
            if (clazz.getDeclaredAnnotation(WebService.class) != null) {
                return true;
            }
            for (Class<?> anInterface : clazz.getInterfaces()) {
                if (anInterface.getDeclaredAnnotation(WebService.class) == null) continue;
                return true;
            }
            clazz = clazz.getSuperclass();
        }
        return false;
    }

    public static JAXBContext getJAXBContextForWebService(Class<?> webService) {
        if (!JAXBSoapUtil.hasWebServiceAnnotation(webService)) {
            throw new IllegalArgumentException("no webservice class");
        }
        HashSet classes = new HashSet();
        JAXBSoapUtil.collect(webService, classes);
        try {
            Class[] classesToBeBound = (Class[])classes.stream().filter(clazz -> clazz.getDeclaredAnnotation(XmlRootElement.class) != null).toArray(Class[]::new);
            return JAXBContext.newInstance((Class[])classesToBeBound);
        }
        catch (JAXBException e) {
            throw new RuntimeException(e);
        }
    }

    private static void collect(Class<?> clazz, Set<Class<?>> classes) {
        for (Method method : clazz.getDeclaredMethods()) {
            if (method.getReturnType() == null) continue;
            if (classes.add(method.getReturnType())) {
                JAXBSoapUtil.collect(method.getReturnType(), classes);
            }
            for (int i = 0; i < method.getParameterCount(); ++i) {
                Class<?> parameterType = method.getParameterTypes()[0];
                if (!classes.add(parameterType)) continue;
                JAXBSoapUtil.collect(parameterType, classes);
            }
            JAXBSoapUtil.collectExceptions(classes, method);
        }
    }

    private static void collectExceptions(Set<Class<?>> classes, Method method) {
        for (Class<?> exceptionClass : method.getExceptionTypes()) {
            if (!classes.add(exceptionClass)) continue;
            JAXBSoapUtil.collect(exceptionClass, classes);
        }
        Class<?> thisClass = method.getDeclaringClass();
        for (Class<?> i : thisClass.getInterfaces()) {
            try {
                Method parentMethod = i.getDeclaredMethod(method.getName(), method.getParameterTypes());
                JAXBSoapUtil.collectExceptions(classes, parentMethod);
            }
            catch (NoSuchMethodException noSuchMethodException) {
                // empty catch block
            }
        }
        for (Class<?> parent = thisClass.getSuperclass(); parent != null; parent = parent.getSuperclass()) {
            try {
                Method parentMethod = parent.getDeclaredMethod(method.getName(), method.getParameterTypes());
                JAXBSoapUtil.collectExceptions(classes, parentMethod);
                return;
            }
            catch (NoSuchMethodException noSuchMethodException) {
                continue;
            }
        }
    }
}

