/*
 * Decompiled with CFR 0.152.
 */
package io.github.factoryfx.soap;

import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.bind.Unmarshaller;
import javax.xml.namespace.QName;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.soap.DetailEntry;
import javax.xml.soap.MessageFactory;
import javax.xml.soap.SOAPConstants;
import javax.xml.soap.SOAPException;
import javax.xml.soap.SOAPFault;
import javax.xml.soap.SOAPMessage;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

public class SOAPMessageUtil {
    private final JAXBContext jaxbContext;
    private final DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
    static final Logger trashMessagesLogger = Logger.getLogger("javax.xml.soap");

    public SOAPMessageUtil(JAXBContext jaxbContext) {
        this.jaxbContext = jaxbContext;
    }

    public Object parseRequest(SOAPMessage soapMessage) {
        try {
            Unmarshaller unmarshaller = this.jaxbContext.createUnmarshaller();
            return unmarshaller.unmarshal(soapMessage.getSOAPBody().getFirstChild());
        }
        catch (JAXBException | SOAPException e) {
            throw new RuntimeException(e);
        }
    }

    public Object parseFault(SOAPFault soapFault) {
        try {
            Object exceptionElement;
            Unmarshaller unmarshaller = this.jaxbContext.createUnmarshaller();
            Object unmarshalledExceptionElement = unmarshaller.unmarshal((Node)soapFault.getDetail().getDetailEntries().next());
            if (unmarshalledExceptionElement instanceof JAXBElement) {
                JAXBElement jaxbElement = (JAXBElement)unmarshalledExceptionElement;
                exceptionElement = jaxbElement.getValue();
            } else {
                exceptionElement = unmarshalledExceptionElement;
            }
            return exceptionElement;
        }
        catch (JAXBException e) {
            throw new RuntimeException(e);
        }
    }

    public SOAPMessage wrapRequest(Object request, MessageFactory messageFactory) {
        try {
            SOAPMessage requestMessage = messageFactory.createMessage();
            Marshaller marshaller = this.jaxbContext.createMarshaller();
            DocumentBuilder db = this.dbf.newDocumentBuilder();
            Document document = db.newDocument();
            marshaller.marshal(request, (Node)document);
            Node importedNode = requestMessage.getSOAPBody().getOwnerDocument().importNode(document.getChildNodes().item(0), true);
            requestMessage.getSOAPBody().appendChild(importedNode);
            requestMessage.saveChanges();
            return requestMessage;
        }
        catch (JAXBException | ParserConfigurationException | SOAPException e) {
            throw new RuntimeException(e);
        }
    }

    public SOAPMessage wrapResponse(Object response, MessageFactory messageFactory) {
        try {
            SOAPMessage responseMessage = messageFactory.createMessage();
            Marshaller marshaller = this.jaxbContext.createMarshaller();
            DocumentBuilder db = this.dbf.newDocumentBuilder();
            Document document = db.newDocument();
            marshaller.marshal(response, (Node)document);
            Node importedNode = responseMessage.getSOAPBody().getOwnerDocument().importNode(document.getChildNodes().item(0), true);
            responseMessage.getSOAPBody().appendChild(importedNode);
            return responseMessage;
        }
        catch (JAXBException | ParserConfigurationException | SOAPException e) {
            throw new RuntimeException(e);
        }
    }

    public SOAPMessage wrapFault(JAXBElement fault, String faultString, MessageFactory messageFactory, boolean soap12) {
        try {
            SOAPMessage responseMessage = messageFactory.createMessage();
            Marshaller marshaller = this.jaxbContext.createMarshaller();
            DocumentBuilder db = this.dbf.newDocumentBuilder();
            Document document = db.newDocument();
            marshaller.marshal((Object)fault, (Node)document);
            Node importedNode = responseMessage.getSOAPBody().getOwnerDocument().importNode(document.getChildNodes().item(0), true);
            SOAPFault soapFault = responseMessage.getSOAPBody().addFault();
            if (soap12) {
                soapFault.setFaultCode(SOAPConstants.SOAP_SENDER_FAULT);
            } else {
                soapFault.setFaultCode(fault.getName());
            }
            soapFault.setFaultString(faultString != null ? faultString : "Unspecified error");
            soapFault.addDetail();
            QName qname = importedNode.getNamespaceURI() != null ? new QName(importedNode.getNamespaceURI(), importedNode.getLocalName(), importedNode.getPrefix()) : new QName(importedNode.getLocalName());
            DetailEntry detailEntry = soapFault.getDetail().addDetailEntry(qname);
            detailEntry.appendChild(importedNode);
            responseMessage.getSOAPBody().appendChild(importedNode);
            return responseMessage;
        }
        catch (JAXBException | ParserConfigurationException | SOAPException e) {
            throw new RuntimeException(e);
        }
    }

    static {
        trashMessagesLogger.setLevel(Level.OFF);
    }
}

