/*
 * Decompiled with CFR 0.152.
 */
package io.github.factoryfx.soap;

import io.github.factoryfx.soap.SOAPMessageUtil;
import io.github.factoryfx.soap.WebServiceCallResult;
import io.github.factoryfx.soap.WebServiceRequestDispatcher;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Iterator;
import java.util.Objects;
import javax.servlet.Servlet;
import javax.servlet.ServletConfig;
import javax.servlet.ServletOutputStream;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.xml.soap.MessageFactory;
import javax.xml.soap.MimeHeader;
import javax.xml.soap.MimeHeaders;
import javax.xml.soap.SOAPException;
import javax.xml.soap.SOAPMessage;
import javax.xml.soap.SOAPPart;
import javax.xml.transform.Source;
import javax.xml.transform.stream.StreamSource;

public class SoapHandler
implements Servlet {
    private final MessageFactory SOAP11FACTORY;
    private final MessageFactory SOAP12FACTORY;
    private final WebServiceRequestDispatcher dispatcher;
    private final SOAPMessageUtil soapMessageUtil;
    ServletConfig config;

    public SoapHandler(WebServiceRequestDispatcher dispatcher, SOAPMessageUtil soapXmlParser) {
        this.dispatcher = dispatcher;
        this.soapMessageUtil = soapXmlParser;
        try {
            this.SOAP11FACTORY = MessageFactory.newInstance((String)"SOAP 1.1 Protocol");
            this.SOAP12FACTORY = MessageFactory.newInstance((String)"SOAP 1.2 Protocol");
        }
        catch (SOAPException e) {
            throw new RuntimeException(e);
        }
    }

    public void service(ServletRequest req, ServletResponse res) throws IOException {
        HttpServletRequest request = (HttpServletRequest)req;
        HttpServletResponse response = (HttpServletResponse)res;
        try {
            SOAPMessage responseMessage;
            MessageFactory messageFactory;
            boolean soap12 = false;
            if (Objects.equals(request.getHeader("Content-Type"), "text/xml")) {
                messageFactory = this.SOAP11FACTORY;
            } else {
                messageFactory = this.SOAP12FACTORY;
                soap12 = true;
            }
            StreamSource messageSource = new StreamSource((InputStream)request.getInputStream());
            SOAPMessage message = messageFactory.createMessage();
            SOAPPart soapPart = message.getSOAPPart();
            soapPart.setContent((Source)messageSource);
            message.saveChanges();
            WebServiceCallResult callResult = this.dispatcher.execute(message, this.soapMessageUtil.parseRequest(message), request, response);
            SOAPMessage sOAPMessage = responseMessage = callResult.result != null ? this.soapMessageUtil.wrapResponse(callResult.result, messageFactory) : this.soapMessageUtil.wrapFault(callResult.createFaultDetail(), callResult.fault.getMessage(), messageFactory, soap12);
            if (responseMessage.saveRequired()) {
                responseMessage.saveChanges();
            }
            response.setStatus(200);
            this.putHeaders(responseMessage.getMimeHeaders(), response);
            ServletOutputStream os = response.getOutputStream();
            responseMessage.writeTo((OutputStream)os);
            os.flush();
        }
        catch (SOAPException e) {
            throw new RuntimeException(e);
        }
    }

    public String getServletInfo() {
        return "SOAP Handler";
    }

    public void destroy() {
    }

    private void putHeaders(MimeHeaders headers, HttpServletResponse res) {
        Iterator it = headers.getAllHeaders();
        while (it.hasNext()) {
            MimeHeader header = (MimeHeader)it.next();
            String[] values = headers.getHeader(header.getName());
            if (values.length == 1) {
                res.setHeader(header.getName(), header.getValue());
                continue;
            }
            StringBuffer concat = new StringBuffer();
            int i = 0;
            while (i < values.length) {
                if (i != 0) {
                    concat.append(',');
                }
                concat.append(values[i++]);
            }
            res.setHeader(header.getName(), concat.toString());
        }
    }

    public void init(ServletConfig config) {
        this.config = config;
    }

    public ServletConfig getServletConfig() {
        return this.config;
    }
}

