/*
 * Decompiled with CFR 0.152.
 */
package io.github.factoryfx.soap;

import io.github.factoryfx.soap.WebServiceCallResult;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.security.Principal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.namespace.QName;
import javax.xml.soap.SOAPMessage;
import javax.xml.ws.EndpointReference;
import javax.xml.ws.WebServiceContext;
import javax.xml.ws.handler.MessageContext;
import javax.xml.ws.handler.soap.SOAPMessageContext;
import org.w3c.dom.Element;

public class WebServiceRequestDispatcher {
    private final Object webService;
    private final HashMap<Class, Invoker> dispatchMap = new HashMap();
    private final ThreadLocal<RequestContext> msgContext = new ThreadLocal();
    private final WebServiceContext webServiceContext = new WebServiceContext(){

        public SOAPMessageContext getMessageContext() {
            return new SOAPMessageContext(){

                public SOAPMessage getMessage() {
                    return this.ctx().soapMessage;
                }

                public void setMessage(SOAPMessage message) {
                    this.ctx().soapMessage = message;
                }

                public Object[] getHeaders(QName header, JAXBContext context, boolean allRoles) {
                    throw new UnsupportedOperationException();
                }

                public Set<String> getRoles() {
                    return Collections.emptySet();
                }

                public void setScope(String name, MessageContext.Scope scope) {
                    throw new UnsupportedOperationException();
                }

                public MessageContext.Scope getScope(String name) {
                    throw new UnsupportedOperationException();
                }

                public int size() {
                    return 6;
                }

                private RequestContext ctx() {
                    return WebServiceRequestDispatcher.this.msgContext.get();
                }

                public boolean isEmpty() {
                    return false;
                }

                public boolean containsKey(Object key) {
                    if (key == null) {
                        return false;
                    }
                    switch (key.toString()) {
                        case "javax.xml.ws.http.request.headers": 
                        case "javax.xml.ws.http.request.method": 
                        case "javax.xml.ws.http.response.code": 
                        case "javax.xml.ws.http.response.headers": 
                        case "javax.xml.ws.servlet.request": 
                        case "javax.xml.ws.servlet.response": {
                            return true;
                        }
                    }
                    return false;
                }

                public boolean containsValue(Object value) {
                    return value == this.ctx().request || value == this.ctx().response || value == this.ctx().soapMessage;
                }

                public Object get(Object key) {
                    if (key == null) {
                        return false;
                    }
                    switch (key.toString()) {
                        case "javax.xml.ws.http.request.headers": {
                            return WebServiceRequestDispatcher.this.buildHeaders(this.ctx().request);
                        }
                        case "javax.xml.ws.http.request.method": {
                            return this.ctx().request.getMethod();
                        }
                        case "javax.xml.ws.http.response.code": {
                            return this.ctx().response.getStatus();
                        }
                        case "javax.xml.ws.http.response.headers": {
                            return WebServiceRequestDispatcher.this.buildHeaders(this.ctx().response);
                        }
                        case "javax.xml.ws.servlet.request": {
                            return this.ctx().request;
                        }
                        case "javax.xml.ws.servlet.response": {
                            return this.ctx().response;
                        }
                    }
                    return null;
                }

                public Object put(String key, Object value) {
                    throw new UnsupportedOperationException();
                }

                public Object remove(Object key) {
                    throw new UnsupportedOperationException();
                }

                public void putAll(Map<? extends String, ?> m) {
                    throw new UnsupportedOperationException();
                }

                public void clear() {
                    throw new UnsupportedOperationException();
                }

                public Set<String> keySet() {
                    return new HashSet<String>(Arrays.asList("javax.xml.ws.http.request.headers", "javax.xml.ws.http.request.method", "javax.xml.ws.http.response.code", "javax.xml.ws.http.response.headers", "javax.xml.ws.servlet.request", "javax.xml.ws.servlet.response"));
                }

                public Collection<Object> values() {
                    return Arrays.asList(this.ctx().soapMessage, WebServiceRequestDispatcher.this.buildHeaders(this.ctx().request), this.ctx().request.getMethod(), this.ctx().response.getStatus(), WebServiceRequestDispatcher.this.buildHeaders(this.ctx().response), this.ctx().request, this.ctx().response);
                }

                public Set<Map.Entry<String, Object>> entrySet() {
                    HashMap<String, SOAPMessage> entries = new HashMap<String, SOAPMessage>();
                    entries.put("javax.xml.ws.http.request.headers", this.ctx().soapMessage);
                    entries.put("javax.xml.ws.http.request.method", this.ctx().soapMessage);
                    entries.put("javax.xml.ws.http.response.code", this.ctx().soapMessage);
                    entries.put("javax.xml.ws.http.response.headers", this.ctx().soapMessage);
                    entries.put("javax.xml.ws.servlet.request", this.ctx().soapMessage);
                    entries.put("javax.xml.ws.servlet.response", this.ctx().soapMessage);
                    return entries.entrySet();
                }
            };
        }

        public Principal getUserPrincipal() {
            return null;
        }

        public boolean isUserInRole(String role) {
            return false;
        }

        public EndpointReference getEndpointReference(Element ... referenceParameters) {
            return null;
        }

        public <T extends EndpointReference> T getEndpointReference(Class<T> clazz, Element ... referenceParameters) {
            return null;
        }
    };
    static final ParameterSupplyer HTTP_REQUEST_SUPPLIER = (req, httpReq, httpResp) -> httpReq;
    static final ParameterSupplyer HTTP_RESPONSE_SUPPLIER = (req, httpReq, httpResp) -> httpResp;
    static final ParameterSupplyer REQUEST_SUPPLIER = (req, httpReq, httpResp) -> req;

    private Map<String, List<String>> buildHeaders(HttpServletRequest request) {
        HashMap<String, List<String>> map = new HashMap<String, List<String>>();
        Enumeration en = request.getHeaderNames();
        while (en.hasMoreElements()) {
            String name = (String)en.nextElement();
            map.put(name, this.enum2list(request.getHeaders(name)));
        }
        return map;
    }

    private Map<String, List<String>> buildHeaders(HttpServletResponse response) {
        HashMap<String, List<String>> map = new HashMap<String, List<String>>();
        for (String name : response.getHeaderNames()) {
            map.put(name, response.getHeaders(name).stream().collect(Collectors.toList()));
        }
        return map;
    }

    private List<String> enum2list(Enumeration<String> e) {
        ArrayList<String> l = new ArrayList<String>();
        while (e.hasMoreElements()) {
            l.add(e.nextElement());
        }
        return l;
    }

    public WebServiceRequestDispatcher(Object webService) {
        this.webService = webService;
        for (Field field : webService.getClass().getDeclaredFields()) {
            if (field.getAnnotation(Resource.class) == null || !field.getType().isAssignableFrom(WebServiceContext.class)) continue;
            field.setAccessible(true);
            try {
                field.set(webService, this.webServiceContext);
            }
            catch (IllegalAccessException e) {
                throw new RuntimeException(e);
            }
        }
        for (AccessibleObject accessibleObject : webService.getClass().getDeclaredMethods()) {
            if (((Method)accessibleObject).getParameterCount() < 1 || ((Method)accessibleObject).getReturnType() == null) continue;
            ParameterSupplyer[] suppliers = new ParameterSupplyer[((Method)accessibleObject).getParameterCount()];
            boolean isWebService = true;
            Class<?> rootElementClass = null;
            for (int i = 0; i < suppliers.length; ++i) {
                if (((Method)accessibleObject).getParameterTypes()[i].isAssignableFrom(HttpServletRequest.class)) {
                    suppliers[i] = HTTP_REQUEST_SUPPLIER;
                    continue;
                }
                if (((Method)accessibleObject).getParameterTypes()[i].isAssignableFrom(HttpServletResponse.class)) {
                    suppliers[i] = HTTP_RESPONSE_SUPPLIER;
                    continue;
                }
                if (((Method)accessibleObject).getParameterTypes()[i].getAnnotation(XmlRootElement.class) != null) {
                    if (rootElementClass != null) {
                        isWebService = false;
                    }
                    suppliers[i] = REQUEST_SUPPLIER;
                    rootElementClass = ((Method)accessibleObject).getParameterTypes()[i];
                    continue;
                }
                isWebService = false;
            }
            if (!isWebService) continue;
            this.dispatchMap.put(rootElementClass, new Invoker((Method)accessibleObject, suppliers));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public WebServiceCallResult execute(SOAPMessage message, Object request, HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) {
        Invoker method = this.dispatchMap.get(request.getClass());
        try {
            this.msgContext.set(new RequestContext(httpServletRequest, httpServletResponse, message));
            WebServiceCallResult webServiceCallResult = WebServiceCallResult.fromResult(method.invoke(this.webService, request, httpServletRequest, httpServletResponse));
            return webServiceCallResult;
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
        catch (InvocationTargetException t) {
            Throwable ex = t.getTargetException();
            if (ex instanceof Error) {
                throw (Error)ex;
            }
            if (ex instanceof RuntimeException) {
                throw (RuntimeException)ex;
            }
            WebServiceCallResult webServiceCallResult = WebServiceCallResult.fromFault((Exception)ex);
            return webServiceCallResult;
        }
        finally {
            this.msgContext.set(null);
        }
    }

    private static class Invoker {
        final Method method;
        final ParameterSupplyer[] suppliers;

        private Invoker(Method method, ParameterSupplyer[] suppliers) {
            this.method = method;
            this.suppliers = suppliers;
        }

        public Object invoke(Object webService, Object request, HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws InvocationTargetException, IllegalAccessException {
            Object[] args = new Object[this.suppliers.length];
            for (int i = 0; i < args.length; ++i) {
                args[i] = this.suppliers[i].supply(request, httpServletRequest, httpServletResponse);
            }
            return this.method.invoke(webService, args);
        }
    }

    private static interface ParameterSupplyer {
        public Object supply(Object var1, HttpServletRequest var2, HttpServletResponse var3);
    }

    static final class RequestContext {
        final HttpServletRequest request;
        final HttpServletResponse response;
        SOAPMessage soapMessage;

        RequestContext(HttpServletRequest request, HttpServletResponse response, SOAPMessage soapMessage) {
            this.request = request;
            this.response = response;
            this.soapMessage = soapMessage;
        }
    }
}

