/*
 * Decompiled with CFR 0.152.
 */
package com.ruiyun.jvppeteer.core.browser;

import com.ruiyun.jvppeteer.events.BrowserListenerWrapper;
import com.ruiyun.jvppeteer.events.DefaultBrowserListener;
import com.ruiyun.jvppeteer.events.EventEmitter;
import com.ruiyun.jvppeteer.exception.LaunchException;
import com.ruiyun.jvppeteer.exception.TimeoutException;
import com.ruiyun.jvppeteer.options.LaunchOptions;
import com.ruiyun.jvppeteer.transport.Connection;
import com.ruiyun.jvppeteer.transport.WebSocketTransport;
import com.ruiyun.jvppeteer.transport.factory.WebSocketTransportFactory;
import com.ruiyun.jvppeteer.util.Helper;
import com.ruiyun.jvppeteer.util.StreamUtil;
import com.ruiyun.jvppeteer.util.StringUtil;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BrowserRunner
extends EventEmitter
implements AutoCloseable {
    private static final Logger LOGGER = LoggerFactory.getLogger(BrowserRunner.class);
    private static final Pattern WS_ENDPOINT_PATTERN = Pattern.compile("^DevTools listening on (ws://.*)$");
    private String executablePath;
    private List<String> processArguments;
    private String tempDirectory;
    private Process process;
    private Connection connection;
    private boolean closed;
    private List<BrowserListenerWrapper> listeners = new ArrayList<BrowserListenerWrapper>();
    private static final List<BrowserRunner> runners = new ArrayList<BrowserRunner>();
    private static boolean isRegisterShutdownHook = false;

    public BrowserRunner(String executablePath, List<String> processArguments, String tempDirectory) {
        this.executablePath = executablePath;
        this.processArguments = processArguments;
        this.tempDirectory = tempDirectory;
        this.closed = true;
    }

    public void start(LaunchOptions options) throws IOException {
        if (this.process != null) {
            throw new RuntimeException("This process has previously been started.");
        }
        ArrayList<String> arguments = new ArrayList<String>();
        arguments.add(this.executablePath);
        arguments.addAll(this.processArguments);
        ProcessBuilder processBuilder = new ProcessBuilder(new String[0]).command(arguments).redirectErrorStream(true);
        this.process = processBuilder.start();
        this.closed = false;
        this.registerHook();
        this.addProcessListener(options);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void registerHook() {
        runners.add(this);
        if (isRegisterShutdownHook) return;
        Class<BrowserRunner> clazz = BrowserRunner.class;
        synchronized (BrowserRunner.class) {
            if (isRegisterShutdownHook) return;
            RuntimeShutdownHookRegistry hook = new RuntimeShutdownHookRegistry();
            hook.register(new Thread(this::close));
            isRegisterShutdownHook = true;
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    private void addProcessListener(LaunchOptions options) {
        DefaultBrowserListener<Object> exitListener = new DefaultBrowserListener<Object>(){

            @Override
            public void onBrowserEvent(Object event) {
                BrowserRunner runner = (BrowserRunner)this.getTarget();
                runner.kill();
            }
        };
        exitListener.setMothod("exit");
        exitListener.setTarget(this);
        this.listeners.add(Helper.addEventListener(this, exitListener.getMothod(), exitListener));
        if (options.getHandleSIGINT()) {
            DefaultBrowserListener<Object> sigintListener = new DefaultBrowserListener<Object>(){

                @Override
                public void onBrowserEvent(Object event) {
                    BrowserRunner runner = (BrowserRunner)this.getTarget();
                    runner.kill();
                }
            };
            sigintListener.setMothod("SIGINT");
            sigintListener.setTarget(this);
            this.listeners.add(Helper.addEventListener(this, sigintListener.getMothod(), sigintListener));
        }
        if (options.getHandleSIGTERM()) {
            DefaultBrowserListener<Object> sigtermListener = new DefaultBrowserListener<Object>(){

                @Override
                public void onBrowserEvent(Object event) {
                    BrowserRunner runner = (BrowserRunner)this.getTarget();
                    runner.close();
                }
            };
            sigtermListener.setMothod("SIGTERM");
            sigtermListener.setTarget(this);
            this.listeners.add(Helper.addEventListener(this, sigtermListener.getMothod(), sigtermListener));
        }
        if (options.getHandleSIGHUP()) {
            DefaultBrowserListener<Object> sighubListener = new DefaultBrowserListener<Object>(){

                @Override
                public void onBrowserEvent(Object event) {
                    BrowserRunner runner = (BrowserRunner)this.getTarget();
                    runner.close();
                }
            };
            sighubListener.setMothod("SIGHUP");
            sighubListener.setTarget(this);
            this.listeners.add(Helper.addEventListener(this, sighubListener.getMothod(), sighubListener));
        }
    }

    public void kill() {
        if (this.process != null && this.process.isAlive()) {
            this.process.destroyForcibly();
        }
        try {
            if (StringUtil.isNotEmpty(this.tempDirectory)) {
                this.removeFolderByCmd(this.tempDirectory);
            }
        }
        catch (Exception e) {
            LOGGER.error("kill chrome process error ", (Throwable)e);
        }
    }

    private void removeFolderByCmd(String path) throws IOException, InterruptedException {
        if (StringUtil.isEmpty(path) || "*".equals(path)) {
            return;
        }
        Process delProcess = null;
        if (Helper.isWindows()) {
            delProcess = Runtime.getRuntime().exec("cmd /c rd /s /q " + path);
        } else if (Helper.isLinux() || Helper.isMac()) {
            String[] cmd = new String[]{"/bin/sh", "-c", "rm -rf " + path};
            delProcess = Runtime.getRuntime().exec(cmd);
        }
        if (!delProcess.waitFor(10000L, TimeUnit.MILLISECONDS)) {
            delProcess.destroyForcibly();
        }
    }

    public Connection setUpConnection(boolean usePipe, int timeout, int slowMo, boolean dumpio) throws InterruptedException {
        if (usePipe) {
            throw new LaunchException("Temporarily not supported pipe connect to chromuim.If you have a pipe connect to chromium idea,pleaze new a issue in github:https://github.com/fanyong920/jvppeteer/issues");
        }
        String waitForWSEndpoint = this.waitForWSEndpoint(timeout, dumpio);
        WebSocketTransport transport = WebSocketTransportFactory.create(waitForWSEndpoint);
        this.connection = new Connection(waitForWSEndpoint, transport, slowMo);
        LOGGER.info("Connect to browser by websocket url: " + waitForWSEndpoint);
        return this.connection;
    }

    private String waitForWSEndpoint(int timeout, boolean dumpio) {
        StreamReader reader = new StreamReader(timeout, dumpio, this.process.getInputStream());
        reader.start();
        return reader.getResult();
    }

    public Process getProcess() {
        return this.process;
    }

    @Override
    public void close() {
        for (int i = 0; i < runners.size(); ++i) {
            BrowserRunner browserRunner = runners.get(i);
            if (browserRunner.getClosed()) {
                return;
            }
            if (StringUtil.isNotEmpty(browserRunner.getTempDirectory())) {
                browserRunner.kill();
                continue;
            }
            if (browserRunner.getConnection() == null) continue;
            try {
                browserRunner.getConnection().send("Browser.close", null, true);
                continue;
            }
            catch (Exception e) {
                browserRunner.kill();
            }
        }
    }

    public boolean closeQuietly() {
        if (this.getClosed()) {
            return true;
        }
        Helper.removeEventListeners(this.listeners);
        if (StringUtil.isNotEmpty(this.tempDirectory)) {
            this.kill();
        } else if (this.connection != null) {
            try {
                this.connection.send("Browser.close", null, false);
            }
            catch (Exception e) {
                this.kill();
            }
        }
        return true;
    }

    public boolean getClosed() {
        return this.closed;
    }

    public String getTempDirectory() {
        return this.tempDirectory;
    }

    public Connection getConnection() {
        return this.connection;
    }

    public static class RuntimeShutdownHookRegistry
    implements ShutdownHookRegistry {
    }

    public static interface ShutdownHookRegistry {
        default public void register(Thread thread) {
            Runtime.getRuntime().addShutdownHook(thread);
        }

        default public void remove(Thread thread) {
            Runtime.getRuntime().removeShutdownHook(thread);
        }
    }

    static class StreamReader {
        private final StringBuilder ws = new StringBuilder();
        private final AtomicBoolean success = new AtomicBoolean(false);
        private final AtomicReference<String> chromeOutput = new AtomicReference<String>("");
        private int timeout;
        private boolean dumpio;
        private InputStream inputStream;
        private Thread readThread;

        public StreamReader(int timeout, boolean dumpio, InputStream inputStream) {
            this.timeout = timeout;
            this.dumpio = dumpio;
            this.inputStream = inputStream;
        }

        public void start() {
            this.readThread = new Thread(() -> {
                StringBuilder chromeOutputBuilder = new StringBuilder();
                BufferedReader reader = null;
                try {
                    String line;
                    reader = new BufferedReader(new InputStreamReader(this.inputStream));
                    while ((line = reader.readLine()) != null) {
                        Matcher matcher;
                        if (this.dumpio) {
                            System.out.println(line);
                        }
                        if ((matcher = WS_ENDPOINT_PATTERN.matcher(line)).find()) {
                            this.ws.append(matcher.group(1));
                            this.success.set(true);
                            break;
                        }
                        if (chromeOutputBuilder.length() != 0) {
                            chromeOutputBuilder.append(System.lineSeparator());
                        }
                        chromeOutputBuilder.append(line);
                        this.chromeOutput.set(chromeOutputBuilder.toString());
                    }
                }
                catch (Exception e) {
                    try {
                        LOGGER.error("Failed to launch the browser process!please see TROUBLESHOOTING: https://github.com/puppeteer/puppeteer/blob/master/docs/troubleshooting.md:", (Throwable)e);
                    }
                    catch (Throwable throwable) {
                        StreamUtil.closeQuietly(reader);
                        throw throwable;
                    }
                    StreamUtil.closeQuietly(reader);
                }
                StreamUtil.closeQuietly(reader);
            });
            this.readThread.start();
        }

        public String getResult() {
            try {
                this.readThread.join(this.timeout);
                if (!this.success.get()) {
                    StreamUtil.close(this.readThread);
                    throw new TimeoutException("Timed out after " + this.timeout + " ms while trying to connect to the browser!Chrome output: " + this.chromeOutput.get());
                }
            }
            catch (InterruptedException e) {
                StreamUtil.close(this.readThread);
                throw new RuntimeException("Interrupted while waiting for dev tools server.", e);
            }
            String url = this.ws.toString();
            if (StringUtil.isEmpty(url)) {
                throw new LaunchException("Can't get WSEndpoint");
            }
            return url;
        }
    }
}

