/*
 * Decompiled with CFR 0.152.
 */
package com.ruiyun.jvppeteer.core.page;

import com.fasterxml.jackson.databind.JsonNode;
import com.ruiyun.jvppeteer.core.page.Frame;
import com.ruiyun.jvppeteer.core.page.Response;
import com.ruiyun.jvppeteer.protocol.fetch.HeaderEntry;
import com.ruiyun.jvppeteer.protocol.network.ErrorCode;
import com.ruiyun.jvppeteer.protocol.network.RequestWillBeSentPayload;
import com.ruiyun.jvppeteer.transport.CDPSession;
import com.ruiyun.jvppeteer.util.Helper;
import com.ruiyun.jvppeteer.util.StringUtil;
import com.ruiyun.jvppeteer.util.ValidateUtil;
import com.sun.org.apache.xerces.internal.impl.dv.util.Base64;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Future;

public class Request {
    private static final Map<Integer, String> STATUS_TEXTS = new HashMap<Integer, String>();
    private CDPSession client;
    private String requestId;
    private boolean isNavigationRequest;
    private String interceptionId;
    private boolean allowInterception;
    private boolean interceptionHandled;
    private Response response;
    private String failureText;
    private String url;
    private String resourceType;
    private String method;
    private String postData;
    private Map<String, String> headers;
    private Frame frame;
    private List<Request> redirectChain;
    private boolean fromMemoryCache;

    public Request() {
    }

    public Request(CDPSession client, Frame frame, String interceptionId, boolean allowInterception, RequestWillBeSentPayload event, List<Request> redirectChain) {
        this.client = client;
        this.requestId = event.getRequestId();
        if (event.getRequestId() != null) {
            if (event.getRequestId().equals(event.getLoaderId())) {
                this.isNavigationRequest = true;
            }
        } else if (event.getLoaderId() == null) {
            this.isNavigationRequest = true;
        }
        this.interceptionId = interceptionId;
        this.allowInterception = allowInterception;
        this.url = event.getRequest().url();
        this.resourceType = event.getType().toLowerCase();
        this.method = event.getRequest().method();
        this.postData = event.getRequest().postData();
        this.headers = new HashMap<String, String>();
        this.frame = frame;
        this.redirectChain = redirectChain;
        this.interceptionHandled = false;
        this.fromMemoryCache = false;
        for (Map.Entry<String, String> entry : event.getRequest().headers.entrySet()) {
            this.headers.put(entry.getKey().toLowerCase(), entry.getValue());
        }
        this.response = null;
        this.failureText = null;
    }

    public Frame frame() {
        return this.frame;
    }

    public String interceptionId() {
        return this.interceptionId;
    }

    public boolean isAllowInterception() {
        return this.allowInterception;
    }

    public String failure() {
        return this.failureText;
    }

    public Future<JsonNode> continueRequest(String url, String method, String postData, Map<String, String> headers) {
        return Helper.commonExecutor().submit(() -> {
            if (this.url().startsWith("data:")) {
                return null;
            }
            ValidateUtil.assertArg(this.isAllowInterception(), "Request Interception is not enabled!");
            ValidateUtil.assertArg(!this.isInterceptionHandled(), "Request is already handled!");
            this.setInterceptionHandled(true);
            HashMap<String, Object> params = new HashMap<String, Object>();
            params.put("requestId", this.interceptionId());
            params.put("url", url);
            params.put("method", method);
            params.put("postData", postData);
            if (headers != null && headers.size() > 0) {
                params.put("headers", this.headersArray(headers));
            }
            return this.client.send("Fetch.continueRequest", params, true);
        });
    }

    public void continueRequest() {
        this.continueRequest(null, null, null, null);
    }

    public Future<JsonNode> respond(int status, Map<String, String> headers, String contentType, String body) {
        return Helper.commonExecutor().submit(() -> {
            if (this.url().startsWith("data:")) {
                return null;
            }
            ValidateUtil.assertArg(this.allowInterception, "Request Interception is not enabled!");
            ValidateUtil.assertArg(!this.interceptionHandled, "Request is already handled!");
            this.setInterceptionHandled(true);
            byte[] responseBody = null;
            if (StringUtil.isNotEmpty(body)) {
                responseBody = body.getBytes(StandardCharsets.UTF_8);
            }
            HashMap<String, String> responseHeaders = new HashMap<String, String>();
            if (headers != null && headers.size() > 0) {
                for (Map.Entry entry : headers.entrySet()) {
                    responseHeaders.put(((String)entry.getKey()).toLowerCase(), (String)entry.getValue());
                }
            }
            if (StringUtil.isNotEmpty(contentType)) {
                responseHeaders.put("content-type", contentType);
            }
            if (responseBody != null && !responseHeaders.containsKey("content-length")) {
                responseHeaders.put("content-length", String.valueOf(responseBody.length));
            }
            HashMap<String, Object> params = new HashMap<String, Object>();
            params.put("requestId", this.interceptionId);
            params.put("responseCode", status);
            params.put("responsePhrase", STATUS_TEXTS.get(status));
            params.put("responseHeaders", this.headersArray(responseHeaders));
            if (responseBody != null) {
                params.put("body", Base64.encode(responseBody));
            }
            return this.client.send("Fetch.fulfillRequest", params, true);
        });
    }

    public Future<JsonNode> abort(ErrorCode errorCode) {
        return Helper.commonExecutor().submit(() -> {
            if (this.url().startsWith("data:")) {
                return null;
            }
            String errorReason = errorCode.getName();
            ValidateUtil.assertArg(this.allowInterception, "Request Interception is not enabled!");
            ValidateUtil.assertArg(!this.interceptionHandled, "Request is already handled!");
            this.setInterceptionHandled(true);
            HashMap<String, Object> params = new HashMap<String, Object>();
            params.put("requestId", this.interceptionId);
            params.put("errorReason", errorReason);
            return this.client.send("Fetch.failRequest", params, true);
        });
    }

    private List<HeaderEntry> headersArray(Map<String, String> headers) {
        ArrayList<HeaderEntry> result = new ArrayList<HeaderEntry>();
        for (Map.Entry<String, String> entry : headers.entrySet()) {
            String value = entry.getValue();
            if (!StringUtil.isNotEmpty(value)) continue;
            result.add(new HeaderEntry(entry.getKey(), value));
        }
        return result;
    }

    public void abort() {
        this.abort(ErrorCode.FAILED);
    }

    public List<Request> redirectChain() {
        return this.redirectChain;
    }

    public Response response() {
        return this.response;
    }

    public String url() {
        return this.url;
    }

    public String method() {
        return this.method;
    }

    public String postData() {
        return this.postData;
    }

    public Map<String, String> headers() {
        return this.headers;
    }

    protected void setResponse(Response response) {
        this.response = response;
    }

    public String requestId() {
        return this.requestId;
    }

    public boolean isNavigationRequest() {
        return this.isNavigationRequest;
    }

    public boolean isInterceptionHandled() {
        return this.interceptionHandled;
    }

    protected void setInterceptionHandled(boolean interceptionHandled) {
        this.interceptionHandled = interceptionHandled;
    }

    protected void setFailureText(String failureText) {
        this.failureText = failureText;
    }

    public String resourceType() {
        return this.resourceType;
    }

    public boolean fromMemoryCache() {
        return this.fromMemoryCache;
    }

    protected void setFromMemoryCache(boolean fromMemoryCache) {
        this.fromMemoryCache = fromMemoryCache;
    }

    static {
        STATUS_TEXTS.put(100, "Continue");
        STATUS_TEXTS.put(101, "Switching Protocols");
        STATUS_TEXTS.put(102, "Processing");
        STATUS_TEXTS.put(103, "Early Hints");
        STATUS_TEXTS.put(200, "OK");
        STATUS_TEXTS.put(201, "Created");
        STATUS_TEXTS.put(202, "Accepted");
        STATUS_TEXTS.put(203, "Non-Authoritative Information");
        STATUS_TEXTS.put(204, "No Content");
        STATUS_TEXTS.put(205, "Reset Content");
        STATUS_TEXTS.put(206, "Partial Content");
        STATUS_TEXTS.put(207, "Multi-Status");
        STATUS_TEXTS.put(208, "Already Reported");
        STATUS_TEXTS.put(226, "IM Used");
        STATUS_TEXTS.put(300, "Multiple Choices");
        STATUS_TEXTS.put(301, "Moved Permanently");
        STATUS_TEXTS.put(302, "Found");
        STATUS_TEXTS.put(303, "See Other");
        STATUS_TEXTS.put(304, "Not Modified");
        STATUS_TEXTS.put(305, "Use Proxy");
        STATUS_TEXTS.put(306, "Switch Proxy");
        STATUS_TEXTS.put(307, "Temporary Redirect");
        STATUS_TEXTS.put(308, "Permanent Redirect");
        STATUS_TEXTS.put(400, "Bad Request");
        STATUS_TEXTS.put(401, "Unauthorized");
        STATUS_TEXTS.put(402, "Payment Required");
        STATUS_TEXTS.put(403, "Forbidden");
        STATUS_TEXTS.put(404, "Not Found");
        STATUS_TEXTS.put(405, "Method Not Allowed");
        STATUS_TEXTS.put(406, "Not Acceptable");
        STATUS_TEXTS.put(407, "Proxy Authentication Required");
        STATUS_TEXTS.put(408, "Request Timeout");
        STATUS_TEXTS.put(409, "Conflict");
        STATUS_TEXTS.put(410, "Gone");
        STATUS_TEXTS.put(411, "Length Required");
        STATUS_TEXTS.put(412, "Precondition Failed");
        STATUS_TEXTS.put(413, "Payload Too Large");
        STATUS_TEXTS.put(414, "URI Too Long");
        STATUS_TEXTS.put(415, "Unsupported Media Type");
        STATUS_TEXTS.put(416, "Range Not Satisfiable");
        STATUS_TEXTS.put(417, "Expectation Failed");
        STATUS_TEXTS.put(418, "I'm a teapot");
        STATUS_TEXTS.put(421, "Misdirected Request");
        STATUS_TEXTS.put(422, "Unprocessable Entity");
        STATUS_TEXTS.put(423, "Locked");
        STATUS_TEXTS.put(424, "Failed Dependency");
        STATUS_TEXTS.put(425, "Too Early");
        STATUS_TEXTS.put(426, "Upgrade Required");
        STATUS_TEXTS.put(428, "Precondition Required");
        STATUS_TEXTS.put(429, "Too Many Requests");
        STATUS_TEXTS.put(431, "Request Header Fields Too Large");
        STATUS_TEXTS.put(451, "Unavailable For Legal Reasons");
        STATUS_TEXTS.put(500, "Internal Server Error");
        STATUS_TEXTS.put(501, "Not Implemented");
        STATUS_TEXTS.put(502, "Bad Gateway");
        STATUS_TEXTS.put(503, "Service Unavailable");
        STATUS_TEXTS.put(504, "Gateway Timeout");
        STATUS_TEXTS.put(505, "HTTP Version Not Supported");
        STATUS_TEXTS.put(506, "Variant Also Negotiates");
        STATUS_TEXTS.put(507, "Insufficient Storage");
        STATUS_TEXTS.put(508, "Loop Detected");
        STATUS_TEXTS.put(510, "Not Extended");
        STATUS_TEXTS.put(511, "Network Authentication Required");
    }
}

