/*
 * Decompiled with CFR 0.152.
 */
package com.ruiyun.jvppeteer.core.page;

import com.fasterxml.jackson.databind.JsonNode;
import com.ruiyun.jvppeteer.core.Constant;
import com.ruiyun.jvppeteer.events.DefaultBrowserListener;
import com.ruiyun.jvppeteer.transport.CDPSession;
import com.ruiyun.jvppeteer.util.Helper;
import com.ruiyun.jvppeteer.util.ValidateUtil;
import java.io.IOException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;

public class Tracing
implements Constant {
    private CDPSession client;
    private boolean recording;
    private String path;

    public Tracing(CDPSession client) {
        this.client = client;
        this.recording = false;
        this.path = "";
    }

    public void start(String path) {
        this.start(path, false, null);
    }

    public void start(String path, boolean screenshots, Set<String> categories) {
        ValidateUtil.assertArg(!this.recording, "Cannot start recording trace while already recording trace.");
        if (categories == null) {
            categories = new HashSet<String>(DEFAULTCATEGORIES);
        }
        if (screenshots) {
            categories.add("disabled-by-default-devtools.screenshot");
        }
        this.path = path;
        this.recording = true;
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("transferMode", "ReturnAsStream");
        params.put("categories", String.join((CharSequence)",", categories));
        this.client.send("Tracing.start", params, true);
    }

    public void stop() {
        DefaultBrowserListener<JsonNode> traceListener = new DefaultBrowserListener<JsonNode>(){

            @Override
            public void onBrowserEvent(JsonNode event) {
                try {
                    Tracing tracing = (Tracing)this.getTarget();
                    Helper.readProtocolStream(tracing.getClient(), event.get("stream").asText(), tracing.getPath(), true);
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        };
        traceListener.setTarget(this);
        traceListener.setMothod("Tracing.tracingComplete");
        this.client.once(traceListener.getMothod(), traceListener);
        this.client.send("Tracing.end", null, true);
        this.recording = false;
    }

    public CDPSession getClient() {
        return this.client;
    }

    public void setClient(CDPSession client) {
        this.client = client;
    }

    public boolean isRecording() {
        return this.recording;
    }

    public void setRecording(boolean recording) {
        this.recording = recording;
    }

    public String getPath() {
        return this.path;
    }

    public void setPath(String path) {
        this.path = path;
    }
}

