/*
 * Decompiled with CFR 0.152.
 */
package com.ruiyun.jvppeteer.core.page;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.TreeNode;
import com.fasterxml.jackson.databind.JsonNode;
import com.ruiyun.jvppeteer.core.Constant;
import com.ruiyun.jvppeteer.core.page.ConsoleAPI;
import com.ruiyun.jvppeteer.core.page.ExecutionContext;
import com.ruiyun.jvppeteer.core.page.JSHandle;
import com.ruiyun.jvppeteer.events.DefaultBrowserListener;
import com.ruiyun.jvppeteer.events.EventEmitter;
import com.ruiyun.jvppeteer.exception.TimeoutException;
import com.ruiyun.jvppeteer.protocol.PageEvaluateType;
import com.ruiyun.jvppeteer.protocol.runtime.ConsoleAPICalledPayload;
import com.ruiyun.jvppeteer.protocol.runtime.ExceptionDetails;
import com.ruiyun.jvppeteer.protocol.runtime.ExecutionContextDescription;
import com.ruiyun.jvppeteer.protocol.runtime.RemoteObject;
import com.ruiyun.jvppeteer.transport.CDPSession;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Worker
extends EventEmitter {
    private static final Logger LOGGER = LoggerFactory.getLogger(Worker.class);
    private CDPSession client;
    private String url;
    private ExecutionContext context;
    private CountDownLatch contextLatch;

    public Worker(final CDPSession client, String url, final ConsoleAPI consoleAPICalled, final Consumer<ExceptionDetails> exceptionThrown) {
        this.client = client;
        this.url = url;
        DefaultBrowserListener<JsonNode> executionContextListener = new DefaultBrowserListener<JsonNode>(){

            @Override
            public void onBrowserEvent(JsonNode event) {
                try {
                    Worker worker = (Worker)this.getTarget();
                    ExecutionContextDescription contextDescription = (ExecutionContextDescription)Constant.OBJECTMAPPER.treeToValue((TreeNode)event.get("context"), ExecutionContextDescription.class);
                    ExecutionContext executionContext = new ExecutionContext(client, contextDescription, null);
                    worker.executionContextCallback(executionContext);
                }
                catch (JsonProcessingException e) {
                    LOGGER.error("executionContextCreated event json process error ", (Throwable)e);
                }
            }
        };
        executionContextListener.setMothod("Runtime.executionContextCreated");
        executionContextListener.setTarget(this);
        this.client.once(executionContextListener.getMothod(), executionContextListener);
        this.client.send("Runtime.enable", null, false);
        DefaultBrowserListener<ConsoleAPICalledPayload> consoleLis = new DefaultBrowserListener<ConsoleAPICalledPayload>(){

            @Override
            public void onBrowserEvent(ConsoleAPICalledPayload event) {
                consoleAPICalled.call(event.getType(), event.getArgs().stream().map(item -> Worker.this.jsHandleFactory((RemoteObject)item)).collect(Collectors.toList()), event.getStackTrace());
            }
        };
        consoleLis.setMothod("Runtime.consoleAPICalled");
        this.client.on(consoleLis.getMothod(), consoleLis);
        DefaultBrowserListener<JsonNode> exceptionLis = new DefaultBrowserListener<JsonNode>(){

            @Override
            public void onBrowserEvent(JsonNode event) {
                try {
                    ExceptionDetails exceptionDetails = (ExceptionDetails)Constant.OBJECTMAPPER.treeToValue((TreeNode)event.get("exceptionDetails"), ExceptionDetails.class);
                    exceptionThrown.accept(exceptionDetails);
                }
                catch (JsonProcessingException e) {
                    LOGGER.error("exceptionThrown event json process error ", (Throwable)e);
                }
            }
        };
        exceptionLis.setMothod("Runtime.exceptionThrown");
        this.client.on(exceptionLis.getMothod(), exceptionLis);
    }

    public JSHandle jsHandleFactory(RemoteObject remoteObject) {
        return new JSHandle(this.context, this.client, remoteObject);
    }

    protected void executionContextCallback(ExecutionContext executionContext) {
        this.setContext(executionContext);
    }

    private ExecutionContext executionContextPromise() throws InterruptedException {
        if (this.context == null) {
            this.setContextLatch(new CountDownLatch(1));
            boolean await = this.getContextLatch().await(30000L, TimeUnit.MILLISECONDS);
            if (!await) {
                throw new TimeoutException("Wait for ExecutionContext timeout");
            }
        }
        return this.context;
    }

    private CountDownLatch getContextLatch() {
        return this.contextLatch;
    }

    private void setContextLatch(CountDownLatch contextLatch) {
        this.contextLatch = contextLatch;
    }

    public void setContext(ExecutionContext context) {
        this.context = context;
    }

    public String url() {
        return this.url;
    }

    public ExecutionContext executionContext() throws InterruptedException {
        return this.executionContextPromise();
    }

    public Object evaluate(String pageFunction, PageEvaluateType type, Object ... args) throws InterruptedException {
        return this.executionContextPromise().evaluate(pageFunction, type, args);
    }

    public Object evaluateHandle(String pageFunction, PageEvaluateType type, Object ... args) throws InterruptedException {
        return this.executionContextPromise().evaluateHandle(pageFunction, type, args);
    }
}

