/*
 * Decompiled with CFR 0.152.
 */
package com.ruiyun.jvppeteer.events;

import com.fasterxml.jackson.core.TreeNode;
import com.fasterxml.jackson.databind.JsonNode;
import com.ruiyun.jvppeteer.core.Constant;
import com.ruiyun.jvppeteer.events.BrowserListener;
import com.ruiyun.jvppeteer.events.DefaultBrowserListener;
import com.ruiyun.jvppeteer.events.Event;
import com.ruiyun.jvppeteer.util.Helper;
import com.ruiyun.jvppeteer.util.ValidateUtil;
import java.io.IOException;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EventEmitter
implements Event {
    private static final Logger LOGGER = LoggerFactory.getLogger(EventEmitter.class);
    private Map<String, Set<DefaultBrowserListener>> listenerMap = new ConcurrentHashMap<String, Set<DefaultBrowserListener>>();
    private AtomicInteger listenerCount = new AtomicInteger(0);

    @Override
    public Event addListener(String method, BrowserListener<?> listener, boolean isOnce) {
        DefaultBrowserListener defaultBrowserListener = (DefaultBrowserListener)listener;
        if (!method.equals(defaultBrowserListener.getMothod())) {
            LOGGER.error("addListener fail:{} is not equals listener.getMothod()[{}]", (Object)method, (Object)defaultBrowserListener.getMothod());
            return this;
        }
        defaultBrowserListener.setIsOnce(isOnce);
        Set<DefaultBrowserListener> browserListeners = this.listenerMap.get(method);
        if (browserListeners == null) {
            Set<DefaultBrowserListener> listeners = Helper.getConcurrentSet();
            this.listenerMap.putIfAbsent(method, listeners);
            listeners.add(defaultBrowserListener);
        } else {
            browserListeners.add(defaultBrowserListener);
        }
        this.listenerCount.incrementAndGet();
        return this;
    }

    @Override
    public Event removeListener(String method, BrowserListener<?> listener) {
        Set<DefaultBrowserListener> defaultBrowserListeners = this.listenerMap.get(method);
        if (ValidateUtil.isNotEmpty(defaultBrowserListeners)) {
            defaultBrowserListeners.remove(listener);
            this.listenerCount.decrementAndGet();
        }
        return this;
    }

    @Override
    public void emit(String method, Object params) {
        ValidateUtil.notNull(method, "method must not be null");
        Set<DefaultBrowserListener> listeners = this.listenerMap.get(method);
        if (ValidateUtil.isEmpty(listeners)) {
            return;
        }
        for (DefaultBrowserListener listener : listeners) {
            if (!listener.getIsAvaliable()) {
                listeners.remove(listener);
                this.listenerCount.decrementAndGet();
                continue;
            }
            if (listener.getIsOnce()) {
                listeners.remove(listener);
                this.listenerCount.decrementAndGet();
            }
            try {
                Object event;
                if (params != null) {
                    Class resolveType = null;
                    Type genericSuperclass = listener.getClass().getGenericSuperclass();
                    if (genericSuperclass instanceof ParameterizedType) {
                        ParameterizedType parameterizedType = (ParameterizedType)genericSuperclass;
                        Type[] actualTypeArguments = parameterizedType.getActualTypeArguments();
                        if (actualTypeArguments.length == 1) {
                            resolveType = (Class)actualTypeArguments[0];
                        }
                    } else {
                        resolveType = listener.getResolveType();
                    }
                    event = JsonNode.class.isAssignableFrom(params.getClass()) ? this.readJsonObject(resolveType, (JsonNode)params) : params;
                } else {
                    event = null;
                }
                this.invokeListener(listener, event);
            }
            catch (IOException e) {
                LOGGER.error("publish event error:", (Throwable)e);
                return;
            }
        }
    }

    @Override
    public Event addListener(String method, BrowserListener<?> listener) {
        return this.addListener(method, listener, false);
    }

    private void invokeListener(DefaultBrowserListener listener, Object event) {
        try {
            if (listener.getIsSync()) {
                Helper.commonExecutor().submit(() -> listener.onBrowserEvent(event));
            } else {
                listener.onBrowserEvent(event);
            }
        }
        finally {
            if (listener.getIsOnce()) {
                listener.setIsAvaliable(false);
            }
        }
    }

    private <T> T readJsonObject(Class<T> clazz, JsonNode jsonNode) throws IOException {
        if (jsonNode == null) {
            throw new IllegalArgumentException("Failed converting null response to clazz " + clazz.getName());
        }
        if (JsonNode.class.isAssignableFrom(clazz)) {
            return (T)jsonNode;
        }
        return (T)Constant.OBJECTMAPPER.treeToValue((TreeNode)jsonNode, clazz);
    }

    public int getListenerCount(String method) {
        Set<DefaultBrowserListener> defaultBrowserListeners = this.listenerMap.get(method);
        int i = 0;
        if (ValidateUtil.isEmpty(defaultBrowserListeners)) {
            return 0;
        }
        for (DefaultBrowserListener listener : defaultBrowserListeners) {
            if (!listener.getIsAvaliable()) continue;
            ++i;
        }
        return i;
    }
}

