/*
 * Decompiled with CFR 0.152.
 */
package com.ruiyun.jvppeteer.launch;

import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.JsonNode;
import com.ruiyun.jvppeteer.core.Constant;
import com.ruiyun.jvppeteer.core.browser.Browser;
import com.ruiyun.jvppeteer.core.browser.BrowserFetcher;
import com.ruiyun.jvppeteer.core.browser.BrowserRunner;
import com.ruiyun.jvppeteer.core.browser.RevisionInfo;
import com.ruiyun.jvppeteer.exception.LaunchException;
import com.ruiyun.jvppeteer.launch.Launcher;
import com.ruiyun.jvppeteer.options.BrowserOptions;
import com.ruiyun.jvppeteer.options.ChromeArgOptions;
import com.ruiyun.jvppeteer.options.FetcherOptions;
import com.ruiyun.jvppeteer.options.LaunchOptions;
import com.ruiyun.jvppeteer.transport.Connection;
import com.ruiyun.jvppeteer.transport.ConnectionTransport;
import com.ruiyun.jvppeteer.transport.WebSocketTransport;
import com.ruiyun.jvppeteer.util.FileUtil;
import com.ruiyun.jvppeteer.util.StreamUtil;
import com.ruiyun.jvppeteer.util.StringUtil;
import com.ruiyun.jvppeteer.util.ValidateUtil;
import java.io.IOException;
import java.net.HttpURLConnection;
import java.net.URI;
import java.net.URL;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.function.Function;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ChromeLauncher
implements Launcher {
    private static final Logger LOGGER = LoggerFactory.getLogger(ChromeLauncher.class);
    private boolean isPuppeteerCore;
    private String projectRoot;
    private String preferredRevision;

    public ChromeLauncher(String projectRoot, String preferredRevision, boolean isPuppeteerCore) {
        this.projectRoot = projectRoot;
        this.preferredRevision = preferredRevision;
        this.isPuppeteerCore = isPuppeteerCore;
    }

    public ChromeLauncher() {
    }

    @Override
    public Browser launch(LaunchOptions options) throws IOException {
        ArrayList<String> chromeArguments = new ArrayList<String>();
        String temporaryUserDataDir = null;
        this.defaultArgs(options, chromeArguments);
        List<String> ignoreDefaultArgs = options.getIgnoreDefaultArgs();
        if (ValidateUtil.isNotEmpty(ignoreDefaultArgs)) {
            chromeArguments.removeAll(ignoreDefaultArgs);
        }
        boolean isCustomUserDir = false;
        boolean isCustomRemoteDebugger = false;
        for (String arg : chromeArguments) {
            if (arg.startsWith("--remote-debugging-")) {
                isCustomRemoteDebugger = true;
                continue;
            }
            if (!arg.startsWith("--user-data-dir")) continue;
            isCustomUserDir = true;
        }
        if (!isCustomUserDir) {
            temporaryUserDataDir = FileUtil.createProfileDir("puppeteer_dev_chrome_profile-");
            chromeArguments.add("--user-data-dir=" + temporaryUserDataDir);
        }
        if (!isCustomRemoteDebugger) {
            chromeArguments.add(options.getPipe() ? "--remote-debugging-pipe" : "--remote-debugging-port=0");
        }
        String chromeExecutable = this.resolveExecutablePath(options.getExecutablePath());
        boolean usePipe = chromeArguments.contains("--remote-debugging-pipe");
        LOGGER.trace("Calling " + chromeExecutable + String.join((CharSequence)" ", chromeArguments));
        BrowserRunner runner = new BrowserRunner(chromeExecutable, chromeArguments, temporaryUserDataDir);
        try {
            runner.start(options);
            Connection connection = runner.setUpConnection(usePipe, options.getTimeout(), options.getSlowMo(), options.getDumpio());
            Function<Object, Object> closeCallback = s -> {
                runner.closeQuietly();
                return null;
            };
            Browser browser = Browser.create(connection, null, options.getIgnoreHTTPSErrors(), options.getViewport(), runner.getProcess(), closeCallback);
            browser.waitForTarget(t -> "page".equals(t.type()), options);
            return browser;
        }
        catch (IOException | InterruptedException e) {
            runner.kill();
            throw new LaunchException("Failed to launch the browser process:" + e.getMessage(), e);
        }
    }

    @Override
    public void defaultArgs(ChromeArgOptions options, List<String> chromeArguments) {
        LaunchOptions launchOptions;
        List<String> args;
        if (StringUtil.isNotEmpty(options.getUserDataDir())) {
            chromeArguments.add("--user-data-dir=" + options.getUserDataDir());
        }
        boolean devtools = options.getDevtools();
        boolean headless = options.getHeadless();
        if (devtools) {
            chromeArguments.add("--auto-open-devtools-for-tabs");
            headless = false;
        }
        if (headless) {
            chromeArguments.add("--headless");
            chromeArguments.add("--hide-scrollbars");
            chromeArguments.add("--mute-audio");
        }
        if (ValidateUtil.isNotEmpty(args = options.getArgs())) {
            chromeArguments.add("about:blank");
            chromeArguments.addAll(args);
        }
        if (options instanceof LaunchOptions && !(launchOptions = (LaunchOptions)options).getIgnoreAllDefaultArgs()) {
            chromeArguments.addAll(Constant.DEFAULT_ARGS);
        }
    }

    @Override
    public String resolveExecutablePath(String chromeExecutable) throws IOException {
        RevisionInfo revisionInfo;
        boolean puppeteerCore = this.getIsPuppeteerCore();
        FetcherOptions fetcherOptions = new FetcherOptions();
        fetcherOptions.setProduct(this.product());
        BrowserFetcher browserFetcher = new BrowserFetcher(this.projectRoot, fetcherOptions);
        if (!puppeteerCore) {
            if (StringUtil.isNotEmpty(chromeExecutable)) {
                boolean assertDir = FileUtil.assertExecutable(chromeExecutable);
                if (!assertDir) {
                    throw new IllegalArgumentException("given chromeExecutable \"" + chromeExecutable + "\" is not executable");
                }
                return chromeExecutable;
            }
            for (int i = 0; i < Constant.EXECUTABLE_ENV.length; ++i) {
                chromeExecutable = env.getEnv(Constant.EXECUTABLE_ENV[i]);
                if (!StringUtil.isNotEmpty(chromeExecutable)) continue;
                boolean assertDir = FileUtil.assertExecutable(chromeExecutable);
                if (!assertDir) {
                    throw new IllegalArgumentException("given chromeExecutable is not is not executable");
                }
                return chromeExecutable;
            }
            String revision = env.getEnv("PUPPETEER_CHROMIUM_REVISION");
            if (StringUtil.isNotEmpty(revision)) {
                RevisionInfo revisionInfo2 = browserFetcher.revisionInfo(revision);
                if (!revisionInfo2.getLocal()) {
                    throw new LaunchException("Tried to use PUPPETEER_CHROMIUM_REVISION env variable to launch browser but did not find executable at: " + revisionInfo2.getExecutablePath());
                }
                return revisionInfo2.getExecutablePath();
            }
            List<String> localRevisions = browserFetcher.localRevisions();
            if (ValidateUtil.isNotEmpty(localRevisions)) {
                localRevisions.sort(Comparator.reverseOrder());
                RevisionInfo revisionInfo3 = browserFetcher.revisionInfo(localRevisions.get(0));
                if (!revisionInfo3.getLocal()) {
                    throw new LaunchException("Tried to use PUPPETEER_CHROMIUM_REVISION env variable to launch browser but did not find executable at: " + revisionInfo3.getExecutablePath());
                }
                return revisionInfo3.getExecutablePath();
            }
            for (int i = 0; i < Constant.PROBABLE_CHROME_EXECUTABLE_PATH.length; ++i) {
                boolean assertDir;
                chromeExecutable = Constant.PROBABLE_CHROME_EXECUTABLE_PATH[i];
                if (!StringUtil.isNotEmpty(chromeExecutable) || !(assertDir = FileUtil.assertExecutable(chromeExecutable))) continue;
                return chromeExecutable;
            }
        }
        if (!(revisionInfo = browserFetcher.revisionInfo(this.preferredRevision)).getLocal()) {
            throw new LaunchException(MessageFormat.format("Could not find browser revision {0}. Pleaze download a browser binary.", this.preferredRevision));
        }
        return revisionInfo.getExecutablePath();
    }

    @Override
    public Browser connect(BrowserOptions options, String browserWSEndpoint, String browserURL, ConnectionTransport transport) {
        try {
            Connection connection;
            if (transport != null) {
                connection = new Connection("", transport, options.getSlowMo());
            } else if (StringUtil.isNotEmpty(browserWSEndpoint)) {
                WebSocketTransport connectionTransport = WebSocketTransport.create(browserWSEndpoint);
                connection = new Connection(browserWSEndpoint, connectionTransport, options.getSlowMo());
            } else if (StringUtil.isNotEmpty(browserURL)) {
                String connectionURL = this.getWSEndpoint(browserURL);
                WebSocketTransport connectionTransport = WebSocketTransport.create(connectionURL);
                connection = new Connection(connectionURL, connectionTransport, options.getSlowMo());
            } else {
                throw new IllegalArgumentException("Exactly one of browserWSEndpoint, browserURL or transport must be passed to puppeteer.connect");
            }
            JsonNode result = connection.send("Target.getBrowserContexts", null, true);
            JavaType javaType = Constant.OBJECTMAPPER.getTypeFactory().constructParametricType(ArrayList.class, new Class[]{String.class});
            Function<Object, Object> closeFunction = t -> {
                connection.send("Browser.close", null, false);
                return null;
            };
            List browserContextIds = (List)Constant.OBJECTMAPPER.readerFor(javaType).readValue(result.get("browserContextIds"));
            return Browser.create(connection, browserContextIds, options.getIgnoreHTTPSErrors(), options.getViewport(), null, closeFunction);
        }
        catch (IOException | InterruptedException e) {
            throw new RuntimeException(e);
        }
    }

    private String getWSEndpoint(String browserURL) throws IOException {
        URI uri = URI.create(browserURL).resolve("/json/version");
        URL url = uri.toURL();
        HttpURLConnection conn = (HttpURLConnection)url.openConnection();
        conn.setRequestMethod("GET");
        conn.connect();
        int responseCode = conn.getResponseCode();
        if (responseCode != 200) {
            throw new RuntimeException("browserURL: " + browserURL + ",HTTP " + responseCode);
        }
        String result = StreamUtil.toString(conn.getInputStream());
        JsonNode jsonNode = Constant.OBJECTMAPPER.readTree(result);
        return jsonNode.get("webSocketDebuggerUrl").asText();
    }

    public boolean getIsPuppeteerCore() {
        return this.isPuppeteerCore;
    }

    public void setIsPuppeteerCore(boolean isPuppeteerCore) {
        this.isPuppeteerCore = isPuppeteerCore;
    }

    @Override
    public String executablePath() throws IOException {
        return this.resolveExecutablePath(null);
    }

    public String product() {
        return "chrome";
    }
}

