/*
 * Decompiled with CFR 0.152.
 */
package com.ruiyun.jvppeteer.transport;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.ruiyun.jvppeteer.core.Constant;
import com.ruiyun.jvppeteer.core.page.TargetInfo;
import com.ruiyun.jvppeteer.events.EventEmitter;
import com.ruiyun.jvppeteer.events.Events;
import com.ruiyun.jvppeteer.exception.ProtocolException;
import com.ruiyun.jvppeteer.transport.CDPSession;
import com.ruiyun.jvppeteer.transport.ConnectionTransport;
import com.ruiyun.jvppeteer.transport.SendMsg;
import com.ruiyun.jvppeteer.transport.WebSocketTransport;
import com.ruiyun.jvppeteer.util.Helper;
import com.ruiyun.jvppeteer.util.StringUtil;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.Consumer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Connection
extends EventEmitter
implements Consumer<String> {
    private static final Logger LOGGER = LoggerFactory.getLogger(Connection.class);
    private final String url;
    private final ConnectionTransport transport;
    private final int delay;
    private static final AtomicLong lastId = new AtomicLong(0L);
    private final Map<Long, SendMsg> callbacks = new ConcurrentHashMap<Long, SendMsg>();
    private final Map<String, CDPSession> sessions = new ConcurrentHashMap<String, CDPSession>();
    private boolean closed;

    public Connection(String url, ConnectionTransport transport, int delay) {
        this.url = url;
        this.transport = transport;
        this.delay = delay;
        if (this.transport instanceof WebSocketTransport) {
            ((WebSocketTransport)this.transport).addMessageConsumer(this);
        }
    }

    public JsonNode send(String method, Map<String, Object> params, boolean isWait) {
        SendMsg message = new SendMsg();
        message.setMethod(method);
        message.setParams(params);
        try {
            if (isWait) {
                message.setCountDownLatch(new CountDownLatch(1));
                long id = this.rawSend(message, true, this.callbacks);
                message.waitForResult(0L, TimeUnit.MILLISECONDS);
                if (StringUtil.isNotEmpty(message.getErrorText())) {
                    throw new ProtocolException(message.getErrorText());
                }
                return this.callbacks.remove(id).getResult();
            }
            this.rawSend(message, false, this.callbacks);
            return null;
        }
        catch (InterruptedException e) {
            throw new ProtocolException(e);
        }
    }

    public JsonNode send(String method, Map<String, Object> params, boolean isWait, CountDownLatch outLatch) {
        SendMsg message = new SendMsg();
        message.setMethod(method);
        message.setParams(params);
        try {
            if (isWait) {
                if (outLatch != null) {
                    message.setCountDownLatch(outLatch);
                } else {
                    message.setCountDownLatch(new CountDownLatch(1));
                }
                long id = this.rawSend(message, true, this.callbacks);
                message.waitForResult(0L, TimeUnit.MILLISECONDS);
                if (StringUtil.isNotEmpty(message.getErrorText())) {
                    throw new ProtocolException(message.getErrorText());
                }
                return this.callbacks.remove(id).getResult();
            }
            if (outLatch != null) {
                message.setNeedRemove(true);
                message.setCountDownLatch(outLatch);
                this.rawSend(message, true, this.callbacks);
            } else {
                this.rawSend(message, false, this.callbacks);
            }
        }
        catch (InterruptedException e) {
            throw new ProtocolException(e);
        }
        return null;
    }

    public long rawSend(SendMsg message, boolean putCallback, Map<Long, SendMsg> callbacks) {
        long id = lastId.incrementAndGet();
        message.setId(id);
        try {
            if (putCallback) {
                callbacks.put(id, message);
            }
            String sendMsg = Constant.OBJECTMAPPER.writeValueAsString((Object)message);
            this.transport.send(sendMsg);
            LOGGER.trace("SEND -> " + sendMsg);
            return id;
        }
        catch (JsonProcessingException e) {
            LOGGER.error("parse message fail:", (Throwable)e);
            return -1L;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onMessage(String message) {
        block20: {
            if (this.delay > 0) {
                try {
                    Thread.sleep(this.delay);
                }
                catch (InterruptedException e) {
                    LOGGER.error("slowMo browser Fail:", (Throwable)e);
                }
            }
            LOGGER.trace("<- RECV " + message);
            try {
                String sessionIdString;
                CDPSession cdpSession;
                JsonNode sessionId;
                JsonNode paramsNode;
                if (!StringUtil.isNotEmpty(message)) break block20;
                JsonNode readTree = Constant.OBJECTMAPPER.readTree(message);
                JsonNode methodNode = readTree.get("method");
                String method = null;
                if (methodNode != null) {
                    method = methodNode.asText();
                }
                if ("Target.attachedToTarget".equals(method)) {
                    paramsNode = readTree.get("params");
                    sessionId = paramsNode.get("sessionId");
                    JsonNode typeNode = paramsNode.get("targetInfo").get("type");
                    cdpSession = new CDPSession(this, typeNode.asText(), sessionId.asText());
                    this.sessions.put(sessionId.asText(), cdpSession);
                } else if ("Target.detachedFromTarget".equals(method) && (cdpSession = this.sessions.get(sessionIdString = (sessionId = (paramsNode = readTree.get("params")).get("sessionId")).asText())) != null) {
                    cdpSession.onClosed();
                    this.sessions.remove(sessionIdString);
                }
                JsonNode objectSessionId = readTree.get("sessionId");
                JsonNode objectId = readTree.get("id");
                if (objectSessionId != null) {
                    String objectSessionIdString = objectSessionId.asText();
                    cdpSession = this.sessions.get(objectSessionIdString);
                    if (cdpSession != null) {
                        cdpSession.onMessage(readTree);
                    }
                    break block20;
                }
                if (objectId != null) {
                    long id = objectId.asLong();
                    SendMsg sendMsg = this.callbacks.get(id);
                    if (sendMsg == null) break block20;
                    try {
                        JsonNode error = readTree.get("error");
                        if (error != null) {
                            if (sendMsg.getCountDownLatch() != null) {
                                sendMsg.setErrorText(Helper.createProtocolError(readTree));
                                sendMsg.getCountDownLatch().countDown();
                                sendMsg.setCountDownLatch(null);
                            }
                        } else {
                            JsonNode result = readTree.get("result");
                            sendMsg.setResult(result);
                            if (sendMsg.getCountDownLatch() != null) {
                                sendMsg.getCountDownLatch().countDown();
                                sendMsg.setCountDownLatch(null);
                            }
                        }
                        break block20;
                    }
                    finally {
                        if (sendMsg.getNeedRemove()) {
                            this.callbacks.remove(id);
                        }
                    }
                }
                JsonNode paramsNode2 = readTree.get("params");
                this.emit(method, paramsNode2);
            }
            catch (Exception e) {
                throw new ProtocolException(e);
            }
        }
    }

    public static Connection fromSession(CDPSession client) {
        return client.getConnection();
    }

    public CDPSession createSession(TargetInfo targetInfo) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("targetId", targetInfo.getTargetId());
        params.put("flatten", true);
        JsonNode result = this.send("Target.attachToTarget", params, true);
        return this.sessions.get(result.get("sessionId").asText());
    }

    public String url() {
        return this.url;
    }

    public String getUrl() {
        return this.url;
    }

    public CDPSession session(String sessionId) {
        return this.sessions.get(sessionId);
    }

    @Override
    public void accept(String t) {
        this.onMessage(t);
    }

    public void dispose() {
        this.onClose();
        this.transport.close();
    }

    private void onClose() {
        if (this.closed) {
            return;
        }
        this.closed = true;
        for (SendMsg callback : this.callbacks.values()) {
            LOGGER.error("Protocol error " + callback.getMethod() + " Target closed.");
        }
        this.callbacks.clear();
        for (CDPSession session : this.sessions.values()) {
            session.onClosed();
        }
        this.sessions.clear();
        this.emit(Events.CONNECTION_DISCONNECTED.getName(), null);
    }

    public boolean getClosed() {
        return this.closed;
    }
}

