/*
 * Decompiled with CFR 0.152.
 */
package com.ruiyun.jvppeteer.transport;

import com.ruiyun.jvppeteer.core.page.Worker;
import com.ruiyun.jvppeteer.transport.ConnectionTransport;
import com.ruiyun.jvppeteer.util.StreamUtil;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PipeTransport
implements ConnectionTransport {
    private static final Logger LOGGER = LoggerFactory.getLogger(Worker.class);
    private InputStream pipeReader;
    private OutputStream pipeWriter;
    private Thread readThread;
    private Thread writerThread;
    private BlockingQueue<String> messageQueue = new LinkedBlockingQueue<String>();
    private StringBuffer pendingMessage = new StringBuffer();

    public PipeTransport() {
    }

    public PipeTransport(InputStream pipeReader, OutputStream pipeWriter) {
        this.pipeReader = pipeReader;
        this.pipeWriter = pipeWriter;
        this.readThread = new Thread(new PipeReaderThread());
        this.readThread.start();
        this.writerThread = new Thread(new PipeWriterThread());
        this.writerThread.start();
    }

    @Override
    public void send(String message) {
        try {
            this.messageQueue.put(message);
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void onMessage(String message) {
    }

    @Override
    public void onClose() {
    }

    @Override
    public void close() {
        StreamUtil.closeQuietly(this.pipeWriter);
        StreamUtil.closeQuietly(this.pipeReader);
    }

    private class PipeReaderThread
    implements Runnable {
        private PipeReaderThread() {
        }

        @Override
        public void run() {
            while (true) {
                try {
                    while (true) {
                        int read;
                        if ((char)(read = PipeTransport.this.pipeReader.read()) != '\u0000') {
                            PipeTransport.this.pendingMessage.append((char)read);
                            continue;
                        }
                        String message = PipeTransport.this.pendingMessage.toString();
                        PipeTransport.this.pendingMessage.delete(0, PipeTransport.this.pendingMessage.length());
                        PipeTransport.this.onMessage(message);
                    }
                }
                catch (IOException e) {
                    LOGGER.error("read message from chrome error ", (Throwable)e);
                    continue;
                }
                break;
            }
        }
    }

    private class PipeWriterThread
    implements Runnable {
        private PipeWriterThread() {
        }

        @Override
        public void run() {
            while (true) {
                try {
                    while (true) {
                        String message = (String)PipeTransport.this.messageQueue.take();
                        PipeTransport.this.pipeWriter.write(message.getBytes());
                        PipeTransport.this.pipeWriter.write(0);
                        PipeTransport.this.pipeWriter.flush();
                    }
                }
                catch (IOException | InterruptedException e) {
                    LOGGER.error("pipe transport send message fail ", (Throwable)e);
                    continue;
                }
                break;
            }
        }
    }
}

