/*
 * Decompiled with CFR 0.152.
 */
package com.ruiyun.jvppeteer.util;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.ruiyun.jvppeteer.core.Constant;
import com.ruiyun.jvppeteer.events.BrowserListenerWrapper;
import com.ruiyun.jvppeteer.events.DefaultBrowserListener;
import com.ruiyun.jvppeteer.events.EventEmitter;
import com.ruiyun.jvppeteer.protocol.PageEvaluateType;
import com.ruiyun.jvppeteer.protocol.runtime.CallFrame;
import com.ruiyun.jvppeteer.protocol.runtime.ExceptionDetails;
import com.ruiyun.jvppeteer.protocol.runtime.RemoteObject;
import com.ruiyun.jvppeteer.transport.CDPSession;
import com.ruiyun.jvppeteer.util.FileUtil;
import com.ruiyun.jvppeteer.util.StreamUtil;
import com.ruiyun.jvppeteer.util.StringUtil;
import com.ruiyun.jvppeteer.util.ValidateUtil;
import com.sun.org.apache.xerces.internal.impl.dv.util.Base64;
import java.beans.BeanInfo;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.math.BigInteger;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.PosixFilePermission;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.CompletionService;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorCompletionService;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingDeque;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Predicate;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Helper {
    private static ExecutorService COMMON_EXECUTOR = null;
    private static final Logger LOGGER = LoggerFactory.getLogger(Helper.class);
    private static final String os = System.getProperty("os.name");
    private static final boolean WINDOWS = os.startsWith("Windows");
    private static final boolean MAC = os.startsWith("Mac");
    private static final boolean LINUX = os.startsWith("Linux");

    public static String createProtocolError(JsonNode node) {
        JsonNode methodNode = node.get("method");
        JsonNode errNode = node.get("error");
        JsonNode errorMsg = errNode.get("message");
        String method = "";
        if (methodNode != null) {
            method = methodNode.asText();
        }
        String message = "Protocol error " + method + ": " + errorMsg;
        JsonNode dataNode = errNode.get("data");
        if (dataNode != null) {
            message = message + " " + dataNode.toString();
        }
        return message;
    }

    public static boolean isWindows() {
        return WINDOWS;
    }

    public static boolean isMac() {
        return MAC;
    }

    public static boolean isLinux() {
        return LINUX;
    }

    public static final boolean isWin64() {
        String arch = System.getProperty("os.arch");
        return arch.contains("64");
    }

    public static final String paltform() {
        return System.getProperty("os.name");
    }

    public static final void chmod(String path, String perms) throws IOException {
        if (StringUtil.isEmpty(path)) {
            throw new IllegalArgumentException("Path must not be empty");
        }
        char[] chars = perms.toCharArray();
        if (chars.length != 3) {
            throw new IllegalArgumentException("perms length must be 3");
        }
        Path path1 = Paths.get(path, new String[0]);
        HashSet<PosixFilePermission> permissions = new HashSet<PosixFilePermission>();
        if ('1' == chars[0]) {
            permissions.add(PosixFilePermission.OWNER_EXECUTE);
        } else if ('2' == chars[0]) {
            permissions.add(PosixFilePermission.OWNER_WRITE);
        } else if ('3' == chars[0]) {
            permissions.add(PosixFilePermission.OWNER_WRITE);
            permissions.add(PosixFilePermission.OWNER_EXECUTE);
        } else if ('4' == chars[0]) {
            permissions.add(PosixFilePermission.OWNER_READ);
        } else if ('5' == chars[0]) {
            permissions.add(PosixFilePermission.OWNER_READ);
            permissions.add(PosixFilePermission.OWNER_EXECUTE);
        } else if ('6' == chars[0]) {
            permissions.add(PosixFilePermission.OWNER_READ);
            permissions.add(PosixFilePermission.OWNER_WRITE);
        } else if ('7' == chars[0]) {
            permissions.add(PosixFilePermission.OWNER_READ);
            permissions.add(PosixFilePermission.OWNER_WRITE);
            permissions.add(PosixFilePermission.OWNER_EXECUTE);
        }
        if ('1' == chars[1]) {
            permissions.add(PosixFilePermission.GROUP_EXECUTE);
        } else if ('2' == chars[1]) {
            permissions.add(PosixFilePermission.GROUP_WRITE);
        } else if ('3' == chars[1]) {
            permissions.add(PosixFilePermission.GROUP_WRITE);
            permissions.add(PosixFilePermission.GROUP_EXECUTE);
        } else if ('4' == chars[1]) {
            permissions.add(PosixFilePermission.GROUP_READ);
        } else if ('5' == chars[1]) {
            permissions.add(PosixFilePermission.GROUP_READ);
            permissions.add(PosixFilePermission.GROUP_EXECUTE);
        } else if ('6' == chars[1]) {
            permissions.add(PosixFilePermission.GROUP_READ);
            permissions.add(PosixFilePermission.GROUP_WRITE);
        } else if ('7' == chars[1]) {
            permissions.add(PosixFilePermission.GROUP_READ);
            permissions.add(PosixFilePermission.GROUP_WRITE);
            permissions.add(PosixFilePermission.GROUP_EXECUTE);
        }
        if ('1' == chars[2]) {
            permissions.add(PosixFilePermission.OTHERS_EXECUTE);
        } else if ('2' == chars[2]) {
            permissions.add(PosixFilePermission.OTHERS_WRITE);
        } else if ('3' == chars[2]) {
            permissions.add(PosixFilePermission.OTHERS_WRITE);
            permissions.add(PosixFilePermission.OTHERS_EXECUTE);
        } else if ('4' == chars[2]) {
            permissions.add(PosixFilePermission.OTHERS_READ);
        } else if ('5' == chars[2]) {
            permissions.add(PosixFilePermission.OTHERS_READ);
            permissions.add(PosixFilePermission.OTHERS_EXECUTE);
        } else if ('6' == chars[2]) {
            permissions.add(PosixFilePermission.OTHERS_READ);
            permissions.add(PosixFilePermission.OWNER_WRITE);
        } else if ('7' == chars[2]) {
            permissions.add(PosixFilePermission.OTHERS_READ);
            permissions.add(PosixFilePermission.OTHERS_WRITE);
            permissions.add(PosixFilePermission.OTHERS_EXECUTE);
        }
        Files.setPosixFilePermissions(path1, permissions);
    }

    public static final String join(String root, String ... args) {
        return Paths.get(root, args).toString();
    }

    public static final Object readProtocolStream(CDPSession client, String handler, String path, boolean isSync) throws IOException {
        if (isSync) {
            return Helper.commonExecutor().submit(() -> {
                try {
                    Helper.printPDF(client, handler, path);
                }
                catch (IOException e) {
                    LOGGER.error("Method readProtocolStream error", (Throwable)e);
                }
            });
        }
        return Helper.printPDF(client, handler, path);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static byte[] printPDF(CDPSession client, String handler, String path) throws IOException {
        byte[] byArray;
        boolean eof = false;
        File file = null;
        BufferedOutputStream writer = null;
        BufferedInputStream reader = null;
        if (StringUtil.isNotEmpty(path)) {
            file = new File(path);
            FileUtil.createNewFile(file);
        }
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("handle", handler);
        try {
            if (file != null) {
                FileOutputStream fileOutputStream = new FileOutputStream(file);
                writer = new BufferedOutputStream(fileOutputStream);
            }
            byte[] buffer = new byte[8192];
            ArrayList<byte[]> bufs = new ArrayList<byte[]>();
            int byteLength = 0;
            while (!eof) {
                String dataText;
                JsonNode response = client.send("IO.read", params, true);
                JsonNode eofNode = response.get("eof");
                JsonNode base64EncodedNode = response.get("base64Encoded");
                JsonNode dataNode = response.get("data");
                if (dataNode != null && StringUtil.isNotEmpty(dataText = dataNode.asText())) {
                    try {
                        byte[] bytes = base64EncodedNode != null && base64EncodedNode.asBoolean() ? Base64.decode(dataText) : dataNode.asText().getBytes();
                        bufs.add(bytes);
                        byteLength += bytes.length;
                        if (file != null) {
                            int read;
                            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(bytes);
                            reader = new BufferedInputStream(byteArrayInputStream);
                            while ((read = reader.read(buffer, 0, 8192)) != -1) {
                                writer.write(buffer, 0, read);
                                writer.flush();
                            }
                        }
                    }
                    finally {
                        StreamUtil.closeQuietly(reader);
                    }
                }
                eof = eofNode == null ? true : eofNode.asBoolean();
            }
            client.send("IO.close", params, true);
            byArray = Helper.getBytes(bufs, byteLength);
        }
        catch (Throwable throwable) {
            StreamUtil.closeQuietly(writer);
            StreamUtil.closeQuietly(reader);
            throw throwable;
        }
        StreamUtil.closeQuietly(writer);
        StreamUtil.closeQuietly(reader);
        return byArray;
    }

    private static byte[] getBytes(List<byte[]> bufs, int byteLength) {
        byte[] resultBuf = new byte[byteLength];
        int destPos = 0;
        for (byte[] buf : bufs) {
            System.arraycopy(buf, 0, resultBuf, destPos, buf.length);
            destPos += buf.length;
        }
        return resultBuf;
    }

    public static String getExceptionMessage(ExceptionDetails exceptionDetails) {
        if (exceptionDetails.getException() != null) {
            return StringUtil.isNotEmpty(exceptionDetails.getException().getDescription()) ? exceptionDetails.getException().getDescription() : (String)exceptionDetails.getException().getValue();
        }
        String message = exceptionDetails.getText();
        StringBuilder sb = new StringBuilder(message);
        if (exceptionDetails.getStackTrace() != null) {
            for (CallFrame callframe : exceptionDetails.getStackTrace().getCallFrames()) {
                String location = callframe.getUrl() + ":" + callframe.getColumnNumber() + ":" + callframe.getColumnNumber();
                String functionName = StringUtil.isNotEmpty(callframe.getFunctionName()) ? callframe.getFunctionName() : "<anonymous>";
                sb.append("\n    at ").append(functionName).append("(").append(location).append(")");
            }
        }
        return sb.toString();
    }

    public static final Set<DefaultBrowserListener> getConcurrentSet() {
        return new CopyOnWriteArraySet<DefaultBrowserListener>();
    }

    public static final <T> BrowserListenerWrapper<T> addEventListener(EventEmitter emitter, String eventName, DefaultBrowserListener<T> handler) {
        emitter.on(eventName, handler);
        return new BrowserListenerWrapper<T>(emitter, eventName, handler);
    }

    public static final void removeEventListeners(List<BrowserListenerWrapper> eventListeners) {
        if (ValidateUtil.isEmpty(eventListeners)) {
            return;
        }
        for (int i = 0; i < eventListeners.size(); ++i) {
            BrowserListenerWrapper wrapper = eventListeners.get(i);
            wrapper.getEmitter().removeListener(wrapper.getEventName(), wrapper.getHandler());
        }
    }

    public static final boolean isString(Object value) {
        if (value == null) {
            return false;
        }
        return value.getClass().equals(String.class);
    }

    public static final boolean isNumber(String s) {
        Pattern pattern = Pattern.compile("-?[0-9]+(\\.[0-9]+)?");
        Matcher matcher = pattern.matcher(s);
        return matcher.matches();
    }

    public static Object valueFromRemoteObject(RemoteObject remoteObject) {
        ValidateUtil.assertArg(StringUtil.isEmpty(remoteObject.getObjectId()), "Cannot extract value when objectId is given");
        if (StringUtil.isNotEmpty(remoteObject.getUnserializableValue())) {
            if ("bigint".equals(remoteObject.getType())) {
                return new BigInteger(remoteObject.getUnserializableValue().replace("n", ""));
            }
            switch (remoteObject.getUnserializableValue()) {
                case "-0": {
                    return 0;
                }
                case "NaN": {
                    return "NaN";
                }
                case "Infinity": {
                    return "Infinity";
                }
                case "-Infinity": {
                    return "-Infinity";
                }
            }
            throw new IllegalArgumentException("Unsupported unserializable value: " + remoteObject.getUnserializableValue());
        }
        return remoteObject.getValue();
    }

    public static void releaseObject(CDPSession client, RemoteObject remoteObject, boolean isBlock) {
        if (isBlock) {
            Helper.releaseObject(client, remoteObject);
        } else {
            Helper.commonExecutor().submit(() -> Helper.releaseObject(client, remoteObject));
        }
    }

    private static void releaseObject(CDPSession client, RemoteObject remoteObject) {
        block3: {
            if (StringUtil.isEmpty(remoteObject.getObjectId())) {
                return;
            }
            HashMap<String, Object> params = new HashMap<String, Object>();
            params.put("objectId", remoteObject.getObjectId());
            try {
                client.send("Runtime.releaseObject", params, true);
            }
            catch (Exception e) {
                if (!LOGGER.isDebugEnabled()) break block3;
                LOGGER.error("", (Throwable)e);
            }
        }
    }

    public static final void copyProperties(Object src, Object dest) throws IntrospectionException, InvocationTargetException, IllegalAccessException {
        PropertyDescriptor[] propertyDescriptors;
        Class<?> destClass = dest.getClass();
        BeanInfo srcBean = Introspector.getBeanInfo(src.getClass());
        for (PropertyDescriptor descriptor : propertyDescriptors = srcBean.getPropertyDescriptors()) {
            PropertyDescriptor destDescriptor = new PropertyDescriptor(descriptor.getName(), destClass);
            destDescriptor.getWriteMethod().invoke(dest, descriptor.getReadMethod().invoke(src, new Object[0]));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Object waitForEvent(EventEmitter eventEmitter, String eventName, final Predicate predicate, int timeout, String abortPromise) throws InterruptedException {
        final CountDownLatch latch = new CountDownLatch(1);
        final Object[] result = new Object[]{null};
        DefaultBrowserListener listener = new DefaultBrowserListener(){

            @Override
            public void onBrowserEvent(Object event) {
                if (!predicate.test(event)) {
                    return;
                }
                result[0] = event;
                latch.countDown();
            }
        };
        listener.setMothod(eventName);
        BrowserListenerWrapper wrapper = Helper.addEventListener(eventEmitter, eventName, listener);
        try {
            boolean await = latch.await(timeout, TimeUnit.MILLISECONDS);
            if (!await) {
                throw new RuntimeException(abortPromise);
            }
            Object object = result[0];
            return object;
        }
        finally {
            ArrayList<BrowserListenerWrapper> removes = new ArrayList<BrowserListenerWrapper>();
            removes.add(wrapper);
            Helper.removeEventListeners(removes);
        }
    }

    public static final String evaluationString(String fun, PageEvaluateType type, Object ... args) {
        if (PageEvaluateType.STRING.equals((Object)type)) {
            ValidateUtil.assertArg(args.length == 0, "Cannot evaluate a string with arguments");
            return fun;
        }
        ArrayList<String> argsList = new ArrayList<String>();
        for (Object arg : args) {
            if (arg == null) {
                argsList.add("undefined");
                continue;
            }
            try {
                argsList.add(Constant.OBJECTMAPPER.writeValueAsString(arg));
            }
            catch (JsonProcessingException e) {
                throw new RuntimeException(e);
            }
        }
        return MessageFormat.format("({0})({1})", fun, String.join((CharSequence)",", argsList));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final ExecutorService commonExecutor() {
        if (COMMON_EXECUTOR != null) return COMMON_EXECUTOR;
        Class<Helper> clazz = Helper.class;
        synchronized (Helper.class) {
            if (COMMON_EXECUTOR != null) return COMMON_EXECUTOR;
            String customNum = System.getProperty("jvppeteer_common_thread_number");
            int threadNum = 0;
            threadNum = StringUtil.isNotEmpty(customNum) ? Integer.parseInt(customNum) : Math.max(1, Runtime.getRuntime().availableProcessors());
            COMMON_EXECUTOR = new ThreadPoolExecutor(threadNum, threadNum, 30L, TimeUnit.SECONDS, new LinkedBlockingDeque<Runnable>(), new CommonThreadFactory());
            // ** MonitorExit[var0] (shouldn't be in output)
            return COMMON_EXECUTOR;
        }
    }

    public static final CompletionService completionService() {
        return new ExecutorCompletionService(Helper.commonExecutor());
    }

    public static final boolean isFunction(String pageFunction) {
        return (pageFunction = pageFunction.trim()).startsWith("function") || pageFunction.startsWith("async") || pageFunction.contains("=>");
    }

    static class CommonThreadFactory
    implements ThreadFactory {
        private static final AtomicInteger poolNumber = new AtomicInteger(1);
        private final ThreadGroup group;
        private final AtomicInteger threadNumber = new AtomicInteger(1);
        private final String namePrefix;

        CommonThreadFactory() {
            SecurityManager s = System.getSecurityManager();
            this.group = s != null ? s.getThreadGroup() : Thread.currentThread().getThreadGroup();
            this.namePrefix = "jvppeteer-common-pool-" + poolNumber.getAndIncrement() + "-thread-";
        }

        @Override
        public Thread newThread(Runnable r) {
            Thread t = new Thread(this.group, r, this.namePrefix + this.threadNumber.getAndIncrement(), 0L);
            t.setDaemon(true);
            if (t.getPriority() != 5) {
                t.setPriority(5);
            }
            return t;
        }
    }
}

