/*
 * Decompiled with CFR 0.152.
 */
package com.ruiyun.jvppeteer.api.core;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.ruiyun.jvppeteer.api.core.BrowserContext;
import com.ruiyun.jvppeteer.api.core.EventEmitter;
import com.ruiyun.jvppeteer.api.core.Page;
import com.ruiyun.jvppeteer.api.core.Target;
import com.ruiyun.jvppeteer.api.events.BrowserEvents;
import com.ruiyun.jvppeteer.cdp.entities.BrowserContextOptions;
import com.ruiyun.jvppeteer.cdp.entities.Cookie;
import com.ruiyun.jvppeteer.cdp.entities.CookieData;
import com.ruiyun.jvppeteer.cdp.entities.DebugInfo;
import com.ruiyun.jvppeteer.cdp.entities.DownloadOptions;
import com.ruiyun.jvppeteer.util.Helper;
import java.util.List;
import java.util.Objects;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class Browser
extends EventEmitter<BrowserEvents>
implements AutoCloseable {
    private static final Logger LOGGER = LoggerFactory.getLogger(Browser.class);
    public volatile boolean autoClose;

    public abstract Process process();

    public BrowserContext createBrowserContext() {
        return this.createBrowserContext(new BrowserContextOptions());
    }

    public abstract BrowserContext createBrowserContext(BrowserContextOptions var1);

    public abstract List<BrowserContext> browserContexts();

    public abstract BrowserContext defaultBrowserContext();

    public abstract String wsEndpoint();

    public abstract Page newPage();

    public abstract <T extends Target> List<T> targets();

    public abstract Target target();

    public Target waitForTarget(Predicate<Target> predicate, int timeout) {
        Supplier<Target> conditionChecker = () -> (Target)Helper.filter(this.targets(), predicate);
        return Helper.waitForCondition(conditionChecker, timeout, "Waiting for target failed: timeout " + timeout + "ms exceeded");
    }

    public Target waitForTarget(Predicate<Target> predicate) {
        return this.waitForTarget(predicate, 30000);
    }

    public List<Page> pages() {
        return this.browserContexts().stream().flatMap(context -> context.pages().stream()).collect(Collectors.toList());
    }

    public abstract String version() throws JsonProcessingException;

    public abstract String userAgent();

    public abstract void disconnect();

    public List<Cookie> cookies() {
        return this.defaultBrowserContext().cookies();
    }

    public void setCookie(CookieData ... cookies) {
        this.defaultBrowserContext().setCookie(cookies);
    }

    public abstract boolean connected();

    @Override
    public void disposeSymbol() {
        try {
            if (Objects.nonNull(this.process())) {
                this.close();
            } else {
                this.disconnect();
            }
        }
        catch (Exception e) {
            LOGGER.error("jvppeteer error", (Throwable)e);
        }
    }

    public abstract DebugInfo debugInfo();

    public abstract void setDownloadBehavior(DownloadOptions var1);

    public abstract void cancelDownload(String var1, String var2);

    public abstract boolean isNetworkEnabled();
}

