/*
 * Decompiled with CFR 0.152.
 */
package com.ruiyun.jvppeteer.api.core;

import com.ruiyun.jvppeteer.api.core.Browser;
import com.ruiyun.jvppeteer.api.core.EventEmitter;
import com.ruiyun.jvppeteer.api.core.Page;
import com.ruiyun.jvppeteer.api.core.Target;
import com.ruiyun.jvppeteer.api.events.BrowserContextEvents;
import com.ruiyun.jvppeteer.cdp.entities.Cookie;
import com.ruiyun.jvppeteer.cdp.entities.CookieData;
import com.ruiyun.jvppeteer.common.Constant;
import com.ruiyun.jvppeteer.common.WebPermission;
import com.ruiyun.jvppeteer.util.Helper;
import java.util.List;
import java.util.Objects;
import java.util.function.Predicate;
import java.util.function.Supplier;

public abstract class BrowserContext
extends EventEmitter<BrowserContextEvents> {
    public abstract List<Target> targets();

    public Target waitForTarget(Predicate<Target> predicate) {
        return this.waitForTarget(predicate, 30000);
    }

    public Target waitForTarget(Predicate<Target> predicate, int timeout) {
        Supplier<Target> conditionChecker = () -> Helper.filter(this.targets(), predicate);
        return Helper.waitForCondition(conditionChecker, timeout, "waiting for target failed: timeout " + timeout + "ms exceeded");
    }

    public abstract List<Page> pages();

    public abstract void overridePermissions(String var1, WebPermission ... var2);

    public abstract void clearPermissionOverrides();

    public abstract Page newPage();

    public abstract Browser browser();

    public abstract void close();

    public abstract List<Cookie> cookies();

    public abstract void setCookie(CookieData ... var1);

    public void deleteCookie(Cookie ... cookies) {
        if (Objects.isNull(cookies)) {
            return;
        }
        for (Cookie cookie : cookies) {
            cookie.setExpires(1L);
            this.setCookie((CookieData)Constant.OBJECTMAPPER.convertValue((Object)cookie, CookieData.class));
        }
    }

    public boolean closed() {
        return !this.browser().browserContexts().contains(this);
    }

    public abstract String id();
}

