/*
 * Decompiled with CFR 0.152.
 */
package com.ruiyun.jvppeteer.api.core;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.ruiyun.jvppeteer.api.core.CDPSession;
import com.ruiyun.jvppeteer.api.core.ElementHandle;
import com.ruiyun.jvppeteer.api.core.EventEmitter;
import com.ruiyun.jvppeteer.api.core.JSHandle;
import com.ruiyun.jvppeteer.api.core.Page;
import com.ruiyun.jvppeteer.api.core.Realm;
import com.ruiyun.jvppeteer.api.core.Response;
import com.ruiyun.jvppeteer.api.events.FrameEvents;
import com.ruiyun.jvppeteer.cdp.core.Accessibility;
import com.ruiyun.jvppeteer.cdp.entities.ClickOptions;
import com.ruiyun.jvppeteer.cdp.entities.EvaluateType;
import com.ruiyun.jvppeteer.cdp.entities.FrameAddScriptTagOptions;
import com.ruiyun.jvppeteer.cdp.entities.FrameAddStyleTagOptions;
import com.ruiyun.jvppeteer.cdp.entities.GoToOptions;
import com.ruiyun.jvppeteer.cdp.entities.WaitForOptions;
import com.ruiyun.jvppeteer.cdp.entities.WaitForSelectorOptions;
import com.ruiyun.jvppeteer.common.DeviceRequestPrompt;
import com.ruiyun.jvppeteer.common.QuerySelector;
import com.ruiyun.jvppeteer.exception.EvaluateException;
import com.ruiyun.jvppeteer.exception.JvppeteerException;
import com.ruiyun.jvppeteer.util.GetQueryHandler;
import com.ruiyun.jvppeteer.util.Helper;
import com.ruiyun.jvppeteer.util.StringUtil;
import com.ruiyun.jvppeteer.util.ValidateUtil;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeoutException;

public abstract class Frame
extends EventEmitter<FrameEvents> {
    protected volatile String id;
    protected volatile String parentId;
    protected Accessibility accessibility;
    public volatile boolean hasStartedLoading;
    protected volatile String name;
    protected ElementHandle document;

    public abstract Page page();

    public abstract Response goTo(String var1, GoToOptions var2);

    public abstract Response waitForNavigation(WaitForOptions var1, Runnable var2);

    public abstract CDPSession client();

    public abstract Accessibility accessibility();

    public abstract Realm mainRealm();

    public abstract Realm isolatedRealm();

    public ElementHandle document() throws JsonProcessingException {
        if (this.document == null) {
            this.document = this.mainRealm().evaluateHandle("() => {\n        return document;\n      }", null).asElement();
        }
        return this.document;
    }

    public void clearDocumentHandle() {
        this.document = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ElementHandle frameElement() throws JsonProcessingException {
        Frame parentFrame = this.parentFrame();
        if (Objects.isNull(parentFrame)) {
            return null;
        }
        JSHandle list = parentFrame.isolatedRealm().evaluateHandle("() => {\n      return document.querySelectorAll('iframe,frame');\n    }", null);
        ElementHandle result = null;
        List<JSHandle> lists = Frame.transposeIterableHandle(list);
        try {
            Iterator<JSHandle> iterator = lists.iterator();
            while (iterator.hasNext()) {
                JSHandle iframe = iterator.next();
                Frame frame = iframe.asElement().contentFrame();
                if (frame == null || !frame.id().equals(this.id)) continue;
                result = iframe.asElement();
                iterator.remove();
                break;
            }
        }
        finally {
            lists.forEach(JSHandle::dispose);
            Optional.of(list).ifPresent(JSHandle::dispose);
        }
        if (Objects.isNull(result)) {
            return null;
        }
        return parentFrame.mainRealm().adoptHandle(result);
    }

    public JSHandle evaluateHandle(String pptrFunction, List<Object> args) throws JsonProcessingException {
        pptrFunction = Helper.withSourcePuppeteerURLIfNone("evaluateHandle", pptrFunction);
        return this.mainRealm().evaluateHandle(pptrFunction, args);
    }

    public Object evaluate(String pptrFunction, EvaluateType type, List<Object> args) throws JsonProcessingException {
        pptrFunction = Helper.withSourcePuppeteerURLIfNone("evaluate", pptrFunction);
        return this.mainRealm().evaluate(pptrFunction, type, args);
    }

    public Object evaluate(String pptrFunction) throws JsonProcessingException {
        return this.evaluate(pptrFunction, null, null);
    }

    public Object evaluate(String pptrFunction, List<Object> args) throws JsonProcessingException {
        return this.evaluate(pptrFunction, null, args);
    }

    public ElementHandle $(String selector) throws JsonProcessingException {
        ElementHandle document = this.document();
        return document.$(selector);
    }

    public List<ElementHandle> $$(String selector) throws JsonProcessingException {
        ElementHandle document = this.document();
        return document.$$(selector);
    }

    public Object $eval(String selector, String pptrFunction, List<Object> args) throws JsonProcessingException {
        pptrFunction = Helper.withSourcePuppeteerURLIfNone("$eval", pptrFunction);
        ElementHandle document = this.document();
        return document.$eval(selector, pptrFunction, args);
    }

    public Object $$eval(String selector, String pptrFunction, List<Object> args) throws JsonProcessingException {
        pptrFunction = Helper.withSourcePuppeteerURLIfNone("$$eval", pptrFunction);
        ElementHandle document = this.document();
        return document.$$eval(selector, pptrFunction, args);
    }

    public ElementHandle waitForSelector(String selector, WaitForSelectorOptions options) throws JsonProcessingException {
        QuerySelector querySelector = GetQueryHandler.getQueryHandlerAndSelector(selector, this);
        options.setPolling(querySelector.getPolling());
        return querySelector.getQueryHandler().waitFor(this, querySelector.getUpdatedSelector(), options);
    }

    public JSHandle waitForFunction(String pptrFunction, WaitForSelectorOptions options, EvaluateType type, Object ... args) throws ExecutionException, InterruptedException, TimeoutException {
        return this.mainRealm().waitForFunction(pptrFunction, options, type, args);
    }

    public String content() throws JsonProcessingException, EvaluateException {
        return (String)this.evaluate("() => {\n      let content = '';\n      for (const node of document.childNodes) {\n        switch (node) {\n          case document.documentElement:\n            content += document.documentElement.outerHTML;\n            break;\n          default:\n            content += new XMLSerializer().serializeToString(node);\n            break;\n        }\n      }\n\n      return content;\n    }");
    }

    public abstract void setContent(String var1, WaitForOptions var2) throws JsonProcessingException, InterruptedException, ExecutionException;

    public void setFrameContent(String content) throws JsonProcessingException {
        this.evaluate("(content) => {\n      document.open();\n      document.write(content);\n      document.close();\n    }", Collections.singletonList(content));
    }

    public String name() {
        return this.name == null ? "" : this.name;
    }

    public abstract String url();

    public abstract Frame parentFrame();

    public abstract <FrameType extends Frame> List<FrameType> childFrames();

    public abstract boolean detached();

    public boolean disposed() {
        return this.detached();
    }

    public ElementHandle addScriptTag(FrameAddScriptTagOptions options) throws IOException, EvaluateException {
        if (options == null) {
            throw new JvppeteerException("Provide an object with a `url`, `path` or `content` property");
        }
        if (StringUtil.isEmpty(options.getUrl()) && StringUtil.isEmpty(options.getPath()) && StringUtil.isEmpty(options.getContent())) {
            throw new JvppeteerException("Provide an object with a `url`, `path` or `content` property");
        }
        if (StringUtil.isEmpty(options.getType())) {
            options.setType("text/javascript");
        }
        if (StringUtil.isNotEmpty(options.getPath())) {
            List<String> contents = Files.readAllLines(Paths.get(options.getPath(), new String[0]), StandardCharsets.UTF_8);
            options.setContent(String.join((CharSequence)"\n", contents) + "//# sourceURL=" + options.getPath().replaceAll("\n", ""));
        }
        return this.mainRealm().evaluateHandle("async ({url, id, type, content}) => {\n    return await new Promise((resolve, reject) => {\n      const script = document.createElement('script');\n      script.type = type;\n      script.text = content;\n      script.addEventListener(\n        'error',\n        event => {\n          reject(new Error(event.message ?? 'Could not load script'));\n        },\n        {once: true}\n      );\n      if (id) {\n        script.id = id;\n      }\n      if (url) {\n        script.src = url;\n        script.addEventListener(\n          'load',\n          () => {\n            resolve(script);\n          },\n          {once: true}\n        );\n        document.head.appendChild(script);\n      } else {\n        document.head.appendChild(script);\n        resolve(script);\n      }\n    });\n  }", Collections.singletonList(options)).asElement();
    }

    public ElementHandle addStyleTag(FrameAddStyleTagOptions options) throws IOException, EvaluateException {
        if (options == null) {
            throw new JvppeteerException("Provide an object with a `url`, `path` or `content` property");
        }
        if (StringUtil.isEmpty(options.getUrl()) && StringUtil.isEmpty(options.getPath()) && StringUtil.isEmpty(options.getContent())) {
            throw new JvppeteerException("Provide an object with a `url`, `path` or `content` property");
        }
        if (StringUtil.isNotEmpty(options.getPath())) {
            List<String> contents = Files.readAllLines(Paths.get(options.getPath(), new String[0]), StandardCharsets.UTF_8);
            String content = String.join((CharSequence)"\n", contents) + "/*# sourceURL=" + options.getPath().replaceAll("\n", "") + "*/";
            options.setContent(content);
        }
        return this.mainRealm().transferHandle(this.isolatedRealm().evaluateHandle("async ({url, content}) => {\n    return await new Promise(\n      (resolve, reject) => {\n        let element;\n        if (!url) {\n          element = document.createElement('style');\n          element.appendChild(document.createTextNode(content));\n        } else {\n          const link = document.createElement('link');\n          link.rel = 'stylesheet';\n          link.href = url;\n          element = link;\n        }\n        element.addEventListener(\n          'load',\n          () => {\n            resolve(element);\n          },\n          {once: true}\n        );\n        element.addEventListener(\n          'error',\n          event => {\n            reject(\n              new Error(\n                (event ).message ?? 'Could not load style'\n              )\n            );\n          },\n          {once: true}\n        );\n        document.head.appendChild(element);\n        return element;\n      }\n    );\n  }", Collections.singletonList(options))).asElement();
    }

    public void click(String selector, ClickOptions options) throws JsonProcessingException, EvaluateException {
        ElementHandle handle = this.$(selector);
        Objects.requireNonNull(handle, "No node found for selector: " + selector);
        handle.click(options);
        handle.dispose();
    }

    public void focus(String selector) throws JsonProcessingException, EvaluateException {
        ElementHandle handle = this.$(selector);
        ValidateUtil.assertArg(handle != null, "No node found for selector: " + selector);
        handle.focus();
        handle.dispose();
    }

    public void hover(String selector) throws JsonProcessingException, EvaluateException {
        ElementHandle handle = this.$(selector);
        ValidateUtil.assertArg(handle != null, "No node found for selector: " + selector);
        handle.hover();
        handle.dispose();
    }

    public List<String> select(String selector, List<String> values) throws JsonProcessingException, EvaluateException {
        ElementHandle handle = this.$(selector);
        ValidateUtil.assertArg(handle != null, "No node found for selector: " + selector);
        List<String> result = handle.select(values);
        handle.dispose();
        return result;
    }

    public void tap(String selector) throws JsonProcessingException, EvaluateException {
        ElementHandle handle = this.$(selector);
        ValidateUtil.assertArg(handle != null, "No node found for selector: " + selector);
        handle.tap();
        handle.dispose();
    }

    public void type(String selector, String text, long delay) throws JsonProcessingException, EvaluateException {
        ElementHandle handle = this.$(selector);
        ValidateUtil.assertArg(handle != null, "No node found for selector: " + selector);
        handle.type(text, delay);
        handle.dispose();
    }

    public String title() throws JsonProcessingException, EvaluateException {
        return (String)this.isolatedRealm().evaluate("() => {\n      return document.title;\n    }", null);
    }

    public abstract DeviceRequestPrompt waitForDevicePrompt(int var1);

    public static List<JSHandle> transposeIterableHandle(JSHandle list) throws JsonProcessingException {
        JSHandle generatorHandle = null;
        try {
            generatorHandle = list.evaluateHandle("iterable => {\n    return (async function* () {\n      yield* iterable;\n    })();\n  }");
            List<JSHandle> list2 = Frame.transposeIteratorHandle(generatorHandle);
            return list2;
        }
        finally {
            Optional.ofNullable(generatorHandle).ifPresent(JSHandle::dispose);
        }
    }

    public static List<JSHandle> transposeIteratorHandle(JSHandle iterator) throws JsonProcessingException, EvaluateException {
        List<JSHandle> result;
        int size = 20;
        ArrayList<JSHandle> results = new ArrayList<JSHandle>();
        while ((result = Frame.fastTransposeIteratorHandle(iterator, size)) != null) {
            results.addAll(result);
            size <<= 1;
        }
        return results;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<JSHandle> fastTransposeIteratorHandle(JSHandle iterator, int size) throws JsonProcessingException, EvaluateException {
        JSHandle array = null;
        try {
            array = iterator.evaluateHandle("async (iterator, size) => {\n    const results = [];\n    while (results.length < size) {\n      const result = await iterator.next();\n      if (result.done) {\n        break;\n      }\n      results.push(result.value);\n    }\n    return results;\n  }", Collections.singletonList(size));
            Map<String, JSHandle> properties = array.getProperties();
            Collection<JSHandle> handles = properties.values();
            if (properties.isEmpty()) {
                List<JSHandle> list = null;
                return list;
            }
            ArrayList<JSHandle> arrayList = new ArrayList<JSHandle>(handles);
            return arrayList;
        }
        finally {
            Optional.ofNullable(array).ifPresent(JSHandle::dispose);
        }
    }

    public String id() {
        return this.id;
    }

    public String parentId() {
        return this.parentId;
    }
}

