/*
 * Decompiled with CFR 0.152.
 */
package com.ruiyun.jvppeteer.api.core;

import com.fasterxml.jackson.databind.node.ObjectNode;
import com.ruiyun.jvppeteer.api.core.TouchHandle;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicLong;

public abstract class Touchscreen {
    protected final List<TouchHandle> touches = new ArrayList<TouchHandle>();
    protected final AtomicLong idGenerator = new AtomicLong(1L);

    public void tap(double x, double y) {
        TouchHandle touch = this.touchStart(x, y, null);
        touch.end();
    }

    public abstract TouchHandle touchStart(double var1, double var3, ObjectNode var5);

    public void touchMove(double x, double y) {
        TouchHandle touch = this.touches.get(0);
        if (Objects.isNull(touch)) {
            throw new NullPointerException("Must start a new Touch first");
        }
        touch.move(x, y);
    }

    public void touchEnd() {
        TouchHandle touch = this.touches.remove(0);
        if (Objects.isNull(touch)) {
            throw new NullPointerException("Must start a new Touch first");
        }
        touch.end();
    }

    public void removeHandle(TouchHandle handle) {
        this.touches.remove(handle);
    }
}

