/*
 * Decompiled with CFR 0.152.
 */
package com.ruiyun.jvppeteer.bidi.core;

import com.fasterxml.jackson.databind.JsonNode;
import com.ruiyun.jvppeteer.api.core.BrowserContext;
import com.ruiyun.jvppeteer.api.core.EventEmitter;
import com.ruiyun.jvppeteer.api.core.Page;
import com.ruiyun.jvppeteer.api.core.Target;
import com.ruiyun.jvppeteer.api.events.BrowserContextEvents;
import com.ruiyun.jvppeteer.api.events.PageEvents;
import com.ruiyun.jvppeteer.api.events.TrustedEmitter;
import com.ruiyun.jvppeteer.bidi.core.BidiBrowser;
import com.ruiyun.jvppeteer.bidi.core.BidiFrame;
import com.ruiyun.jvppeteer.bidi.core.BidiFrameTarget;
import com.ruiyun.jvppeteer.bidi.core.BidiPage;
import com.ruiyun.jvppeteer.bidi.core.BidiPageTarget;
import com.ruiyun.jvppeteer.bidi.core.BidiWebWorker;
import com.ruiyun.jvppeteer.bidi.core.BidiWorkerTarget;
import com.ruiyun.jvppeteer.bidi.core.BrowsingContext;
import com.ruiyun.jvppeteer.bidi.core.UserContext;
import com.ruiyun.jvppeteer.bidi.entities.BytesValue;
import com.ruiyun.jvppeteer.bidi.entities.CreateBrowsingContextOptions;
import com.ruiyun.jvppeteer.bidi.entities.CreateType;
import com.ruiyun.jvppeteer.bidi.entities.GetCookiesOptions;
import com.ruiyun.jvppeteer.bidi.entities.PartialCookie;
import com.ruiyun.jvppeteer.bidi.entities.PermissionOverride;
import com.ruiyun.jvppeteer.bidi.entities.PermissionState;
import com.ruiyun.jvppeteer.cdp.entities.Cookie;
import com.ruiyun.jvppeteer.cdp.entities.CookieData;
import com.ruiyun.jvppeteer.cdp.entities.Viewport;
import com.ruiyun.jvppeteer.common.Constant;
import com.ruiyun.jvppeteer.common.WebPermission;
import com.ruiyun.jvppeteer.exception.JvppeteerException;
import com.ruiyun.jvppeteer.util.Helper;
import com.ruiyun.jvppeteer.util.ValidateUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.WeakHashMap;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BidiBrowserContext
extends BrowserContext {
    protected static final Logger LOGGER = LoggerFactory.getLogger(BidiBrowserContext.class);
    private final TrustedEmitter<BrowserContextEvents> trustedEmitter = new TrustedEmitter();
    private final BidiBrowser browser;
    private final Viewport defaultViewport;
    final UserContext userContext;
    private final Map<BrowsingContext, BidiPage> pages = new WeakHashMap<BrowsingContext, BidiPage>();
    private final Map<BidiPage, Map<BidiPageTarget, Map<Object, Target>>> targets = new ConcurrentHashMap<BidiPage, Map<BidiPageTarget, Map<Object, Target>>>();
    private final List<PermissionOverride> overrides = new ArrayList<PermissionOverride>();

    private BidiBrowserContext(BidiBrowser browser, UserContext userContext, Viewport defaultViewport) {
        this.browser = browser;
        this.userContext = userContext;
        this.defaultViewport = defaultViewport;
        this.trustedEmitter.pipeTo(this);
    }

    public static BidiBrowserContext from(BidiBrowser browser, UserContext userContext, Viewport defaultViewport) {
        BidiBrowserContext context = new BidiBrowserContext(browser, userContext, defaultViewport);
        context.initialize();
        return context;
    }

    private void initialize() {
        for (BrowsingContext browsingContext : this.userContext.browsingContexts()) {
            this.createPage(browsingContext);
        }
        this.userContext.on(UserContext.UserContextEvent.browsingcontext, browsingcontext -> {
            BidiPage page = this.createPage((BrowsingContext)browsingcontext);
            browsingcontext.on(BrowsingContext.BrowsingContextEvents.DOMContentLoaded, ignored -> {
                if (Objects.nonNull(browsingcontext.originalOpener())) {
                    for (BrowsingContext context : this.userContext.browsingContexts()) {
                        if (!browsingcontext.originalOpener().equals(context.id())) continue;
                        this.pages.get(context).trustedEmitter().emit(PageEvents.Popup, page);
                    }
                }
            });
        });
        this.userContext.on(UserContext.UserContextEvent.closed, ignored -> this.trustedEmitter.removeAllListeners(null));
    }

    private BidiPage createPage(BrowsingContext browsingContext) {
        BidiPage page = BidiPage.from(this, browsingContext);
        this.pages.put(browsingContext, page);
        page.trustedEmitter().on(PageEvents.Close, ignored -> this.pages.remove(browsingContext));
        BidiPageTarget pageTarget = new BidiPageTarget(page);
        HashMap bidiPages = new HashMap();
        HashMap pageTargets = new HashMap();
        bidiPages.put(pageTarget, pageTargets);
        this.targets.put(page, bidiPages);
        page.trustedEmitter().on(PageEvents.FrameAttached, bidiFrame -> {
            BidiFrameTarget target = new BidiFrameTarget((BidiFrame)bidiFrame);
            pageTargets.put(bidiFrame, target);
            this.trustedEmitter().emit(BrowserContextEvents.TargetCreated, target);
        });
        page.trustedEmitter().on(PageEvents.FrameNavigated, bidiFrame -> {
            BidiFrameTarget target = (BidiFrameTarget)pageTargets.get(bidiFrame);
            if (Objects.isNull(target)) {
                this.trustedEmitter.emit(BrowserContextEvents.TargetChanged, pageTarget);
            } else {
                this.trustedEmitter.emit(BrowserContextEvents.TargetChanged, target);
            }
        });
        page.trustedEmitter().on(PageEvents.FrameDetached, bidiFrame -> {
            BidiFrameTarget target = (BidiFrameTarget)pageTargets.get(bidiFrame);
            if (Objects.isNull(target)) {
                return;
            }
            pageTargets.remove(bidiFrame);
            this.trustedEmitter.emit(BrowserContextEvents.TargetDestroyed, target);
        });
        page.trustedEmitter().on(PageEvents.WorkerCreated, bidiWorker -> {
            BidiWorkerTarget target = new BidiWorkerTarget((BidiWebWorker)bidiWorker);
            pageTargets.put(bidiWorker, target);
            this.trustedEmitter.emit(BrowserContextEvents.TargetCreated, target);
        });
        page.trustedEmitter().on(PageEvents.WorkerDestroyed, bidiWorker -> {
            BidiWorkerTarget target = (BidiWorkerTarget)pageTargets.get(bidiWorker);
            if (Objects.isNull(target)) {
                return;
            }
            pageTargets.remove(bidiWorker);
            this.trustedEmitter.emit(BrowserContextEvents.TargetDestroyed, target);
        });
        page.trustedEmitter().on(PageEvents.Close, ignored -> {
            this.targets.remove(page);
            this.trustedEmitter.emit(BrowserContextEvents.TargetDestroyed, pageTarget);
        });
        this.trustedEmitter.emit(BrowserContextEvents.TargetCreated, pageTarget);
        return page;
    }

    @Override
    public List<Target> targets() {
        return this.targets.values().stream().map(Map::entrySet).flatMap(entrySet -> {
            ArrayList<BidiPageTarget> targets = new ArrayList<BidiPageTarget>();
            for (Map.Entry entry : entrySet) {
                BidiPageTarget target = (BidiPageTarget)entry.getKey();
                targets.add(target);
                targets.addAll(((Map)entry.getValue()).values());
            }
            return targets.stream();
        }).collect(Collectors.toList());
    }

    @Override
    public List<Page> pages() {
        return this.userContext.browsingContexts().stream().map(this.pages::get).collect(Collectors.toList());
    }

    @Override
    public void overridePermissions(String origin, WebPermission ... webPermissions) {
        ArrayList<String> permissions = new ArrayList<String>();
        if (Objects.nonNull(webPermissions)) {
            for (WebPermission permission2 : webPermissions) {
                if (!Constant.WEB_PERMISSION_TO_PROTOCOL_PERMISSION.containsKey((Object)permission2)) {
                    throw new JvppeteerException("Unknown permission: " + (Object)((Object)permission2));
                }
                permissions.add(permission2.getPermission());
            }
        }
        Constant.WEB_PERMISSION_TO_PROTOCOL_PERMISSION.keySet().forEach(permission -> {
            try {
                this.userContext.setPermissions(origin, permission.getPermission(), permissions.contains(permission.getPermission()) ? PermissionState.Granted : PermissionState.Denied);
                this.overrides.add(new PermissionOverride(origin, (WebPermission)((Object)permission)));
            }
            catch (Exception e) {
                LOGGER.error("jvppeteer error", (Throwable)e);
            }
        });
    }

    @Override
    public void clearPermissionOverrides() {
        for (PermissionOverride override : this.overrides) {
            try {
                this.userContext.setPermissions(override.getOrigin(), override.getPermission().getPermission(), PermissionState.Prompt);
            }
            catch (Exception e) {
                LOGGER.error("jvppeteer error", (Throwable)e);
            }
        }
        this.overrides.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Page newPage() {
        BidiBrowserContext bidiBrowserContext = this;
        synchronized (bidiBrowserContext) {
            BrowsingContext context = this.userContext.createBrowsingContext(CreateType.Tab, new CreateBrowsingContextOptions());
            Page page = this.pages.get(context);
            Objects.requireNonNull(page, "Page is not found");
            if (Objects.nonNull(this.defaultViewport)) {
                try {
                    page.setViewport(this.defaultViewport);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            return page;
        }
    }

    @Override
    public BidiBrowser browser() {
        return this.browser;
    }

    @Override
    public void close() {
        ValidateUtil.assertArg(!Objects.equals("default", this.userContext.id()), "Default BrowserContext cannot be closed!");
        try {
            this.userContext.remove();
        }
        catch (Exception e) {
            LOGGER.error("jvppeteer error", (Throwable)e);
        }
        this.targets.clear();
    }

    @Override
    public List<Cookie> cookies() {
        List<JsonNode> cookies = this.userContext.getCookies(new GetCookiesOptions(), null);
        ArrayList<Cookie> result = new ArrayList<Cookie>();
        for (JsonNode cookie : cookies) {
            result.add(Helper.bidiToPuppeteerCookie(cookie));
        }
        return result;
    }

    @Override
    public void setCookie(CookieData ... cookies) {
        if (Objects.isNull(cookies)) {
            return;
        }
        for (CookieData cookie : cookies) {
            PartialCookie bidiCookie = new PartialCookie();
            bidiCookie.setDomain(cookie.getDomain());
            bidiCookie.setName(cookie.getName());
            bidiCookie.setValue(new BytesValue("string", cookie.getValue()));
            bidiCookie.setPath(cookie.getPath());
            bidiCookie.setHttpOnly(cookie.getHttpOnly());
            bidiCookie.setSecure(cookie.getSecure());
            if (Objects.nonNull((Object)cookie.getSameSite())) {
                bidiCookie.setSameSite(Helper.convertCookiesSameSiteCdpToBiDi(cookie.getSameSite()));
            }
            bidiCookie.setExpiry(cookie.getExpires());
            bidiCookie.setSameParty(cookie.getSameParty());
            bidiCookie.setSourceScheme(cookie.getSourceScheme());
            bidiCookie.setPriority(cookie.getPriority());
            this.userContext.setCookie(bidiCookie, Helper.convertCookiesPartitionKeyFromPuppeteerToBiDi(cookie.getPartitionKey()));
        }
    }

    @Override
    public String id() {
        if (Objects.equals("default", this.userContext.id())) {
            return null;
        }
        return this.userContext.id();
    }

    EventEmitter<BrowserContextEvents> trustedEmitter() {
        return this.trustedEmitter;
    }
}

