/*
 * Decompiled with CFR 0.152.
 */
package com.ruiyun.jvppeteer.bidi.core;

import com.fasterxml.jackson.databind.JsonNode;
import com.ruiyun.jvppeteer.bidi.entities.RemoteValue;
import com.ruiyun.jvppeteer.common.Constant;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Objects;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BidiDeserializer {
    private static final Logger LOGGER = LoggerFactory.getLogger(BidiDeserializer.class);

    public static Object deserialize(RemoteValue result) {
        if (result == null) {
            LOGGER.error("Service did not produce a result.");
            return null;
        }
        switch (result.getType()) {
            case "array": {
                ArrayList<Object> array = new ArrayList<Object>();
                Iterator arrayElements = result.getValue().elements();
                while (arrayElements.hasNext()) {
                    JsonNode element = (JsonNode)arrayElements.next();
                    array.add(BidiDeserializer.deserialize((RemoteValue)Constant.OBJECTMAPPER.convertValue((Object)element, RemoteValue.class)));
                }
                return array;
            }
            case "set": {
                ArrayList<Object> set = new ArrayList<Object>();
                Iterator setElements = result.getValue().elements();
                while (setElements.hasNext()) {
                    JsonNode element = (JsonNode)setElements.next();
                    set.add(BidiDeserializer.deserialize((RemoteValue)Constant.OBJECTMAPPER.convertValue((Object)element, RemoteValue.class)));
                }
                return set;
            }
            case "object": {
                HashMap<Object, Object> objectResult = new HashMap<Object, Object>();
                JsonNode resultValue = result.getValue();
                if (Objects.nonNull(resultValue)) {
                    Iterator objectElements = resultValue.elements();
                    while (objectElements.hasNext()) {
                        JsonNode element = (JsonNode)objectElements.next();
                        JsonNode key = element.get(0);
                        JsonNode value = element.get(1);
                        if (key.isTextual()) {
                            objectResult.put(key.asText(), BidiDeserializer.deserialize((RemoteValue)Constant.OBJECTMAPPER.convertValue((Object)value, RemoteValue.class)));
                            continue;
                        }
                        objectResult.put(BidiDeserializer.deserialize((RemoteValue)Constant.OBJECTMAPPER.convertValue((Object)key, RemoteValue.class)), BidiDeserializer.deserialize((RemoteValue)Constant.OBJECTMAPPER.convertValue((Object)value, RemoteValue.class)));
                    }
                }
                return Constant.OBJECTMAPPER.convertValue(objectResult, Object.class);
            }
            case "map": {
                HashMap<Object, Object> mapResult = new HashMap<Object, Object>();
                Iterator mapElements = result.getValue().elements();
                while (mapElements.hasNext()) {
                    JsonNode element = (JsonNode)mapElements.next();
                    JsonNode key = element.get(0);
                    JsonNode value = element.get(1);
                    if (key.isTextual()) {
                        mapResult.put(key.asText(), BidiDeserializer.deserialize((RemoteValue)Constant.OBJECTMAPPER.convertValue((Object)value, RemoteValue.class)));
                        continue;
                    }
                    mapResult.put(BidiDeserializer.deserialize((RemoteValue)Constant.OBJECTMAPPER.convertValue((Object)key, RemoteValue.class)), BidiDeserializer.deserialize((RemoteValue)Constant.OBJECTMAPPER.convertValue((Object)value, RemoteValue.class)));
                }
                return mapResult;
            }
            case "promise": {
                return new HashMap();
            }
            case "regexp": {
                return Pattern.compile(result.getValue().get("pattern").asText(), BidiDeserializer.convertJsFlagsToJavaFlags(result.getValue().get("flags").asText()));
            }
            case "date": {
                return new Date(result.getValue().asLong());
            }
            case "undefined": {
                return null;
            }
            case "null": {
                return null;
            }
            case "number": {
                return BidiDeserializer.deserializeNumber(result.getValue());
            }
            case "bigint": {
                return new BigInteger(result.getValue().asText());
            }
            case "boolean": {
                return result.getValue().asBoolean();
            }
            case "string": {
                return result.getValue().asText();
            }
        }
        LOGGER.error("Deserialization of type {} not supported.", (Object)result.getType());
        return null;
    }

    private static Object deserializeNumber(JsonNode value) {
        switch (value.asText()) {
            case "-0": {
                return 0;
            }
            case "NaN": {
                return Double.NaN;
            }
            case "Infinity": {
                return Double.POSITIVE_INFINITY;
            }
            case "-Infinity": {
                return Double.NEGATIVE_INFINITY;
            }
        }
        return Double.valueOf(value.asText());
    }

    public static int convertJsFlagsToJavaFlags(String jsFlags) {
        int javaFlags = 0;
        if (jsFlags.contains("i")) {
            javaFlags |= 2;
        }
        if (jsFlags.contains("m")) {
            javaFlags |= 8;
        }
        if (jsFlags.contains("s")) {
            javaFlags |= 0x20;
        }
        if (jsFlags.contains("u")) {
            javaFlags |= 0x40;
        }
        return javaFlags;
    }
}

