/*
 * Decompiled with CFR 0.152.
 */
package com.ruiyun.jvppeteer.bidi.core;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.ruiyun.jvppeteer.api.core.CDPSession;
import com.ruiyun.jvppeteer.api.core.Frame;
import com.ruiyun.jvppeteer.api.core.JSHandle;
import com.ruiyun.jvppeteer.api.core.Response;
import com.ruiyun.jvppeteer.api.events.PageEvents;
import com.ruiyun.jvppeteer.bidi.core.BidiCdpSession;
import com.ruiyun.jvppeteer.bidi.core.BidiDeserializer;
import com.ruiyun.jvppeteer.bidi.core.BidiDialog;
import com.ruiyun.jvppeteer.bidi.core.BidiElementHandle;
import com.ruiyun.jvppeteer.bidi.core.BidiExposeableFunction;
import com.ruiyun.jvppeteer.bidi.core.BidiFrameRealm;
import com.ruiyun.jvppeteer.bidi.core.BidiJSHandle;
import com.ruiyun.jvppeteer.bidi.core.BidiLifeCycleWatch;
import com.ruiyun.jvppeteer.bidi.core.BidiPage;
import com.ruiyun.jvppeteer.bidi.core.BidiRealm;
import com.ruiyun.jvppeteer.bidi.core.BidiRealmCore;
import com.ruiyun.jvppeteer.bidi.core.BidiRequest;
import com.ruiyun.jvppeteer.bidi.core.BidiResponse;
import com.ruiyun.jvppeteer.bidi.core.BidiWebWorker;
import com.ruiyun.jvppeteer.bidi.core.BrowsingContext;
import com.ruiyun.jvppeteer.bidi.core.Navigation;
import com.ruiyun.jvppeteer.bidi.core.ReadinessState;
import com.ruiyun.jvppeteer.bidi.core.RequestCore;
import com.ruiyun.jvppeteer.bidi.entities.LogEntry;
import com.ruiyun.jvppeteer.bidi.entities.RemoteValue;
import com.ruiyun.jvppeteer.bidi.entities.SharedReference;
import com.ruiyun.jvppeteer.cdp.core.Accessibility;
import com.ruiyun.jvppeteer.cdp.entities.CallFrame;
import com.ruiyun.jvppeteer.cdp.entities.ConsoleMessage;
import com.ruiyun.jvppeteer.cdp.entities.ConsoleMessageLocation;
import com.ruiyun.jvppeteer.cdp.entities.ConsoleMessageType;
import com.ruiyun.jvppeteer.cdp.entities.GoToOptions;
import com.ruiyun.jvppeteer.cdp.entities.StackTrace;
import com.ruiyun.jvppeteer.cdp.entities.TargetInfo;
import com.ruiyun.jvppeteer.cdp.entities.WaitForNetworkIdleOptions;
import com.ruiyun.jvppeteer.cdp.entities.WaitForOptions;
import com.ruiyun.jvppeteer.common.AwaitableResult;
import com.ruiyun.jvppeteer.common.BindingFunction;
import com.ruiyun.jvppeteer.common.Constant;
import com.ruiyun.jvppeteer.common.DeviceRequestPrompt;
import com.ruiyun.jvppeteer.common.PuppeteerLifeCycle;
import com.ruiyun.jvppeteer.common.TimeoutSettings;
import com.ruiyun.jvppeteer.exception.EvaluateException;
import com.ruiyun.jvppeteer.exception.JvppeteerException;
import com.ruiyun.jvppeteer.transport.CdpConnection;
import com.ruiyun.jvppeteer.util.Helper;
import com.ruiyun.jvppeteer.util.StringUtil;
import com.ruiyun.jvppeteer.util.ValidateUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.ExecutionException;
import java.util.function.Consumer;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BidiFrame
extends Frame {
    protected static final Logger LOGGER = LoggerFactory.getLogger(BidiFrame.class);
    private final BidiCdpSession client;
    private BidiPage bidiPage;
    private BidiFrame bidiFrame;
    BrowsingContext browsingContext;
    Map<String, BidiFrameRealm> realms = new HashMap<String, BidiFrameRealm>();
    private static final String DEFAULT = "default";
    private static final String INTERNAL = "internal";
    Accessibility accessibility;
    private final Map<BrowsingContext, BidiFrame> frames = new HashMap<BrowsingContext, BidiFrame>();
    private final Map<String, BidiExposeableFunction> exposedFunctions = new HashMap<String, BidiExposeableFunction>();

    public BidiFrame(BidiFrame parent, BrowsingContext browsingContext) {
        this.bidiFrame = parent;
        this.browsingContext = browsingContext;
        this.id = browsingContext.id();
        this.client = new BidiCdpSession(this, null);
        this.realms.put(DEFAULT, BidiFrameRealm.from(this.browsingContext.defaultRealm(), this));
        this.realms.put(INTERNAL, BidiFrameRealm.from(this.browsingContext.createWindowRealm("__puppeteer_internal_" + Math.ceil(Math.random() * 10000.0)), this));
        this.accessibility = new Accessibility(this.realms.get(DEFAULT), this.id);
    }

    public BidiFrame(BidiPage parent, BrowsingContext browsingContext) {
        this.bidiPage = parent;
        this.browsingContext = browsingContext;
        this.id = browsingContext.id();
        this.client = new BidiCdpSession(this, null);
        this.realms.put(DEFAULT, BidiFrameRealm.from(this.browsingContext.defaultRealm(), this));
        this.realms.put(INTERNAL, BidiFrameRealm.from(this.browsingContext.createWindowRealm("__puppeteer_internal_" + Math.ceil(Math.random() * 10000.0)), this));
        this.accessibility = new Accessibility(this.realms.get(DEFAULT), this.id);
    }

    public static BidiFrame from(BidiFrame parent, BrowsingContext browsingContext) {
        BidiFrame frame = new BidiFrame(parent, browsingContext);
        frame.initialize();
        return frame;
    }

    public static BidiFrame from(BidiPage parent, BrowsingContext browsingContext) {
        BidiFrame frame = new BidiFrame(parent, browsingContext);
        frame.initialize();
        return frame;
    }

    private void initialize() {
        for (BrowsingContext child : this.browsingContext.children()) {
            this.createFrameTarget(child);
        }
        this.browsingContext.on(BrowsingContext.BrowsingContextEvents.browsingcontext, this::createFrameTarget);
        this.browsingContext.on(BrowsingContext.BrowsingContextEvents.closed, ignored -> {
            for (BidiCdpSession session : BidiCdpSession.sessions.values()) {
                if (session.frame != this) continue;
                session.onClosed();
            }
            this.page().trustedEmitter().emit(PageEvents.FrameDetached, this);
        });
        this.browsingContext.on(BrowsingContext.BrowsingContextEvents.request, request -> {
            BidiRequest httpRequest = BidiRequest.from(request, this, null);
            request.once(RequestCore.RequestCoreEvents.success, ignored -> this.page().trustedEmitter().emit(PageEvents.RequestFinished, httpRequest));
            request.once(RequestCore.RequestCoreEvents.error, ignored -> this.page().trustedEmitter().emit(PageEvents.RequestFailed, httpRequest));
            httpRequest.finalizeInterceptions();
        });
        this.browsingContext.on(BrowsingContext.BrowsingContextEvents.navigation, navigation -> navigation.once(Navigation.NavigationEvents.fragment, ignored -> this.page().trustedEmitter().emit(PageEvents.FrameNavigated, this)));
        this.browsingContext.on(BrowsingContext.BrowsingContextEvents.load, ignored -> this.page().trustedEmitter().emit(PageEvents.Load, true));
        this.browsingContext.on(BrowsingContext.BrowsingContextEvents.DOMContentLoaded, ignored -> {
            this.hasStartedLoading = true;
            this.page().trustedEmitter().emit(PageEvents.Domcontentloaded, true);
            this.page().trustedEmitter().emit(PageEvents.FrameNavigated, this);
        });
        this.browsingContext.on(BrowsingContext.BrowsingContextEvents.userprompt, userPrompt -> this.page().trustedEmitter().emit(PageEvents.Dialog, BidiDialog.from(userPrompt)));
        this.browsingContext.on(BrowsingContext.BrowsingContextEvents.log, entry -> {
            if (!Objects.equals(this.id, entry.getSource().getContext())) {
                return;
            }
            if (this.isConsoleLogEntry((LogEntry)entry)) {
                List<JSHandle> args = entry.getArgs().stream().map(arg -> this.mainRealm().createHandle((RemoteValue)arg)).collect(Collectors.toList());
                StringBuilder text = new StringBuilder();
                for (Object t : args) {
                    Object parsedValue;
                    if (t instanceof BidiJSHandle) {
                        BidiJSHandle jsHandle = (BidiJSHandle)t;
                        parsedValue = jsHandle.isPrimitiveValue() ? BidiDeserializer.deserialize(jsHandle.remoteValue()) : jsHandle.toString();
                    } else {
                        BidiElementHandle elementHandle = (BidiElementHandle)t;
                        parsedValue = elementHandle.toString();
                    }
                    text.append(parsedValue).append(" ");
                }
                if (text.length() > 0) {
                    text.deleteCharAt(text.length() - 1);
                    this.page().trustedEmitter().emit(PageEvents.Console, new ConsoleMessage(this.convertConsoleMessageLevel(entry.getMethod()), text.toString(), args, this.getStackTraceLocations(entry.getStackTrace()), this));
                }
            } else if (this.isJavaScriptLogEntry((LogEntry)entry)) {
                StringBuilder stackLines = new StringBuilder();
                if (Objects.nonNull(entry.getStackTrace())) {
                    for (CallFrame frame : entry.getStackTrace().getCallFrames()) {
                        stackLines.append("    at ").append(frame.getFunctionName()).append(" ").append(frame.getUrl()).append(":").append(frame.getLineNumber() + 1).append(":").append(frame.getColumnNumber() + 1).append("\n");
                    }
                }
                String message = StringUtil.isEmpty(entry.getText()) ? stackLines.toString() : stackLines + entry.getText();
                EvaluateException error = new EvaluateException(message);
                this.page().trustedEmitter().emit(PageEvents.PageError, error);
            } else {
                LOGGER.error("Unhandled LogEntry with type {}, text {} and level {}", new Object[]{entry.getType(), entry.getText(), entry.getLevel()});
            }
        });
        this.browsingContext.on(BrowsingContext.BrowsingContextEvents.worker, realm -> {
            BidiWebWorker worker = BidiWebWorker.from(this, realm);
            realm.on(BidiRealmCore.RealmCoreEvents.destroyed, reason -> this.page().trustedEmitter().emit(PageEvents.WorkerDestroyed, worker));
            this.page().trustedEmitter().emit(PageEvents.WorkerCreated, worker);
        });
    }

    private BidiFrame createFrameTarget(BrowsingContext browsingContext) {
        BidiFrame frame = BidiFrame.from(this, browsingContext);
        this.frames.put(browsingContext, frame);
        this.page().trustedEmitter().emit(PageEvents.FrameAttached, frame);
        browsingContext.on(BrowsingContext.BrowsingContextEvents.closed, ignored -> this.frames.remove(browsingContext));
        return frame;
    }

    public TimeoutSettings timeoutSettings() {
        return this.page()._timeoutSettings;
    }

    @Override
    public BidiFrameRealm mainRealm() {
        return this.realms.get(DEFAULT);
    }

    @Override
    public BidiFrameRealm isolatedRealm() {
        return this.realms.get(INTERNAL);
    }

    public BidiRealm realm(String id) {
        for (BidiFrameRealm realm : this.realms.values()) {
            if (!Objects.equals(realm.realm.id, id)) continue;
            return realm;
        }
        return null;
    }

    @Override
    public BidiPage page() {
        BidiPage bidiPage = this.bidiPage;
        BidiFrame bidiFrame = this.bidiFrame;
        while (Objects.nonNull(bidiFrame)) {
            bidiPage = bidiFrame.bidiPage;
            bidiFrame = bidiFrame.bidiFrame;
        }
        return bidiPage;
    }

    @Override
    public String url() {
        return this.browsingContext.url();
    }

    @Override
    public Frame parentFrame() {
        if (Objects.nonNull(this.bidiFrame)) {
            return this.bidiFrame;
        }
        return null;
    }

    public List<BidiFrame> childFrames() {
        return this.browsingContext.children().stream().map(this.frames::get).collect(Collectors.toList());
    }

    @Override
    public Response goTo(String url, GoToOptions options) {
        ValidateUtil.assertArg(!this.detached(), "Attempted to use detached Frame " + this.id);
        Runnable navigateRunner = () -> {
            block2: {
                try {
                    this.browsingContext.navigate(url, ReadinessState.Interactive, true);
                }
                catch (Exception e) {
                    if (Objects.equals("net::ERR_HTTP_RESPONSE_CODE_FAILURE", e.getMessage()) || Objects.equals("navigation canceled", e.getMessage())) break block2;
                    Helper.rewriteNavigationError(url, Objects.isNull(options.getTimeout()) ? this.timeoutSettings().navigationTimeout() : options.getTimeout().intValue(), e);
                }
            }
        };
        try {
            return this.waitForNavigation((WaitForOptions)Constant.OBJECTMAPPER.convertValue((Object)options, WaitForOptions.class), navigateRunner);
        }
        catch (Exception e) {
            Helper.rewriteNavigationError(url, Objects.isNull(options.getTimeout()) ? this.timeoutSettings().navigationTimeout() : options.getTimeout().intValue(), e);
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public BidiResponse waitForNavigation(WaitForOptions options, Runnable navigateRunner) {
        BidiLifeCycleWatch lifeCycleWatch = new BidiLifeCycleWatch(this, options);
        Optional.ofNullable(navigateRunner).ifPresent(Runnable::run);
        try {
            Supplier<Boolean> conditionCheck = () -> {
                if (lifeCycleWatch.checkNavigationFinished()) {
                    return true;
                }
                return null;
            };
            int timeout = Objects.isNull(options.getTimeout()) ? this.timeoutSettings().navigationTimeout() : options.getTimeout().intValue();
            Helper.waitForCondition(conditionCheck, timeout, "Waiting for navigation failed: timeout " + timeout + "ms exceeded");
            this.waitForNetworkIdle(options);
            BidiResponse bidiResponse = lifeCycleWatch.getResponse();
            return bidiResponse;
        }
        finally {
            lifeCycleWatch.dispose();
        }
    }

    private void waitForNetworkIdle(WaitForOptions options) {
        ValidateUtil.assertArg(!this.detached(), "Attempted to use detached Frame " + this.id);
        if (Objects.isNull(options)) {
            options = new WaitForOptions();
        }
        List<PuppeteerLifeCycle> waitUntils = Objects.nonNull(options.getWaitUntil()) ? options.getWaitUntil() : Collections.singletonList(PuppeteerLifeCycle.load);
        int timeout = Objects.nonNull(options.getTimeout()) ? options.getTimeout().intValue() : this.timeoutSettings().timeout();
        int concurrency = Integer.MAX_VALUE;
        for (PuppeteerLifeCycle waitUntil : waitUntils) {
            switch (waitUntil) {
                case networkIdle: {
                    concurrency = 0;
                    break;
                }
                case networkIdle2: {
                    concurrency = 2;
                }
            }
        }
        if (concurrency == Integer.MAX_VALUE) {
            return;
        }
        this.page().waitForNetworkIdle(new WaitForNetworkIdleOptions(500, concurrency, timeout));
    }

    private Navigation requestFinished(Navigation navigation, RequestCore request) {
        if (Objects.nonNull(request)) {
            if (Objects.nonNull(request.response()) || Objects.nonNull(request.error())) {
                return navigation;
            }
            if (Objects.nonNull(request.redirect())) {
                return this.requestFinished(navigation, request.redirect());
            }
            AwaitableResult successFuture = new AwaitableResult();
            request.once(RequestCore.RequestCoreEvents.success, info -> successFuture.complete(true));
            AwaitableResult errorFuture = new AwaitableResult();
            request.once(RequestCore.RequestCoreEvents.error, errorMsg -> errorFuture.complete(true));
            AwaitableResult redirectFuture = new AwaitableResult();
            request.once(RequestCore.RequestCoreEvents.redirect, requestCore -> {
                this.requestFinished(navigation, (RequestCore)requestCore);
                redirectFuture.complete(true);
            });
            while (!(successFuture.isDone() || errorFuture.isDone() || redirectFuture.isDone())) {
            }
            return navigation;
        }
        return navigation;
    }

    @Override
    public void setContent(String html, WaitForOptions options) throws JsonProcessingException, InterruptedException, ExecutionException {
        ValidateUtil.assertArg(!this.detached(), "Attempted to use detached Frame " + this.id);
        int timeout = Objects.isNull(options.getTimeout()) ? this.timeoutSettings().navigationTimeout() : options.getTimeout().intValue();
        BidiLifeCycleWatch lifeCycleWatch = new BidiLifeCycleWatch(this, options);
        this.setFrameContent(html);
        Supplier<Boolean> conditionCheck = () -> {
            if (lifeCycleWatch.loadFinished()) {
                return true;
            }
            return null;
        };
        Helper.waitForCondition(conditionCheck, timeout, "Waiting for setContent failed: timeout " + timeout + "ms exceeded");
        this.waitForNetworkIdle(options);
    }

    @Override
    public DeviceRequestPrompt waitForDevicePrompt(int timeout) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean detached() {
        return this.browsingContext.closed();
    }

    public void exposeFunction(String name, BindingFunction apply) {
        if (this.exposedFunctions.containsKey(name)) {
            throw new JvppeteerException("Failed to add page binding with name " + name + ": globalThis['" + name + "'] already exists!");
        }
        BidiExposeableFunction exposeable = BidiExposeableFunction.from(this, name, apply, false);
        this.exposedFunctions.put(name, exposeable);
    }

    @Override
    public BidiCdpSession client() {
        return this.client;
    }

    @Override
    public Accessibility accessibility() {
        return this.accessibility;
    }

    public void removeExposedFunction(String name) {
        BidiExposeableFunction exposedFunction = this.exposedFunctions.remove(name);
        if (Objects.isNull(exposedFunction)) {
            throw new JvppeteerException("Failed to remove page binding with name " + name + " window[" + name + "] does not exists!");
        }
        exposedFunction.dispose();
    }

    public CDPSession createCDPSession() {
        if (!this.page().browser().cdpSupported()) {
            throw new UnsupportedOperationException();
        }
        CdpConnection cdpConnection = this.page().browser().cdpConnection();
        TargetInfo targetInfo = new TargetInfo();
        targetInfo.setTargetId(this.id);
        return cdpConnection._createSession(targetInfo, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void waitForLoad(WaitForOptions options, Runnable navigateRunner) {
        int timeout;
        ValidateUtil.assertArg(!this.detached(), "Attempted to use detached Frame " + this.id);
        if (Objects.isNull(options)) {
            options = new WaitForOptions();
        }
        List<PuppeteerLifeCycle> waitUntil = Objects.nonNull(options.getWaitUntil()) ? options.getWaitUntil() : Collections.singletonList(PuppeteerLifeCycle.load);
        int n = timeout = Objects.nonNull(options.getTimeout()) ? options.getTimeout().intValue() : this.timeoutSettings().navigationTimeout();
        if (ValidateUtil.isEmpty(waitUntil)) {
            waitUntil = Collections.singletonList(PuppeteerLifeCycle.load);
        }
        HashSet events = new HashSet();
        AwaitableResult<Boolean> loadResult = new AwaitableResult<Boolean>();
        AwaitableResult<Boolean> domResult = new AwaitableResult<Boolean>();
        Consumer<Object> loadListener = event -> loadResult.complete(true);
        Consumer<Object> domListener = event -> domResult.complete(true);
        waitUntil.forEach(value -> {
            switch (value) {
                case load: {
                    events.add(value.getValue());
                    this.browsingContext.once(BrowsingContext.BrowsingContextEvents.load, loadListener);
                    break;
                }
                case domcontentloaded: {
                    events.add(value.getValue());
                    this.browsingContext.once(BrowsingContext.BrowsingContextEvents.DOMContentLoaded, domListener);
                }
            }
        });
        if (events.isEmpty()) {
            return;
        }
        if (!waitUntil.contains((Object)PuppeteerLifeCycle.load)) {
            loadResult.complete(true);
        }
        if (!waitUntil.contains((Object)PuppeteerLifeCycle.domcontentloaded)) {
            domResult.complete(true);
        }
        AwaitableResult detachedResult = new AwaitableResult();
        Consumer<Frame> detachedListener = detachedFrame -> {
            if (detachedFrame == this || this.detached()) {
                detachedResult.complete(true);
            }
        };
        this.page().trustedEmitter().once(PageEvents.FrameDetached, detachedListener);
        Optional.ofNullable(navigateRunner).ifPresent(Runnable::run);
        Supplier<Boolean> conditionalCheck = () -> {
            if (detachedResult.isDone()) {
                throw new JvppeteerException("Frame detached.");
            }
            if (loadResult.isDone() && domResult.isDone()) {
                return true;
            }
            return null;
        };
        try {
            Helper.waitForCondition(conditionalCheck, timeout, "Waiting for load failed: timeout " + timeout + "ms exceeded");
        }
        finally {
            this.page().trustedEmitter().off(PageEvents.FrameDetached, detachedListener);
            this.browsingContext.off(BrowsingContext.BrowsingContextEvents.DOMContentLoaded, domListener);
            this.browsingContext.off(BrowsingContext.BrowsingContextEvents.load, loadListener);
        }
    }

    public void setFiles(BidiElementHandle elementHandle, List<String> files) throws JsonProcessingException {
        ValidateUtil.assertArg(!this.detached(), "Attempted to use detached Frame " + this.id);
        SharedReference reference = (SharedReference)Constant.OBJECTMAPPER.readValue(Constant.OBJECTMAPPER.writeValueAsString((Object)elementHandle.remoteValue()), SharedReference.class);
        this.browsingContext.setFiles(reference, files);
    }

    public List<RemoteValue> locateNodes(BidiElementHandle elementHandle, ObjectNode locator) throws JsonProcessingException {
        ValidateUtil.assertArg(!this.detached(), "Attempted to use detached Frame " + this.id);
        SharedReference reference = (SharedReference)Constant.OBJECTMAPPER.readValue(Constant.OBJECTMAPPER.writeValueAsString((Object)elementHandle.remoteValue()), SharedReference.class);
        return this.browsingContext.locateNodes(locator, Collections.singletonList(reference));
    }

    private boolean isConsoleLogEntry(LogEntry entry) {
        return "console".equals(entry.getType());
    }

    private boolean isJavaScriptLogEntry(LogEntry entry) {
        return "javascript".equals(entry.getType());
    }

    private List<ConsoleMessageLocation> getStackTraceLocations(StackTrace stackTrace) {
        ArrayList<ConsoleMessageLocation> stackTraceLocations = new ArrayList<ConsoleMessageLocation>();
        if (Objects.nonNull(stackTrace)) {
            for (CallFrame callFrame : stackTrace.getCallFrames()) {
                stackTraceLocations.add(new ConsoleMessageLocation(callFrame.getUrl(), callFrame.getLineNumber(), callFrame.getColumnNumber()));
            }
        }
        return stackTraceLocations;
    }

    private ConsoleMessageType convertConsoleMessageLevel(String method) {
        switch (method) {
            case "group": {
                return ConsoleMessageType.startGroup;
            }
            case "groupCollapsed": {
                return ConsoleMessageType.startGroupCollapsed;
            }
            case "groupEnd": {
                return ConsoleMessageType.endGroup;
            }
            case "assert": {
                return ConsoleMessageType.Assert;
            }
        }
        return ConsoleMessageType.valueOf(method);
    }
}

