/*
 * Decompiled with CFR 0.152.
 */
package com.ruiyun.jvppeteer.cdp.core;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.TreeNode;
import com.fasterxml.jackson.databind.JsonNode;
import com.ruiyun.jvppeteer.api.core.ElementHandle;
import com.ruiyun.jvppeteer.api.core.Frame;
import com.ruiyun.jvppeteer.api.core.Realm;
import com.ruiyun.jvppeteer.cdp.core.AXNode;
import com.ruiyun.jvppeteer.cdp.entities.SerializedAXNode;
import com.ruiyun.jvppeteer.cdp.entities.SnapshotOptions;
import com.ruiyun.jvppeteer.common.Constant;
import com.ruiyun.jvppeteer.util.StringUtil;
import com.ruiyun.jvppeteer.util.ValidateUtil;
import java.beans.IntrospectionException;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.Set;

public class Accessibility {
    private final Realm realm;
    private String frameId = "";

    public Accessibility(Realm realm, String frameId) {
        this.realm = realm;
        this.frameId = frameId;
    }

    public SerializedAXNode snapshot() throws JsonProcessingException, IllegalAccessException, IntrospectionException, InvocationTargetException {
        return this.snapshot(new SnapshotOptions());
    }

    public SerializedAXNode snapshot(SnapshotOptions options) throws JsonProcessingException, IllegalAccessException, IntrospectionException, InvocationTargetException {
        String finalBackendNodeId;
        JsonNode response = this.realm.environment().client().send("Accessibility.getFullAXTree", Constant.OBJECTMAPPER.createObjectNode().put("frameId", this.frameId));
        JsonNode nodes = response.get("nodes");
        String backendNodeId = null;
        if (Objects.nonNull(options.getRoot())) {
            HashMap<String, String> params = new HashMap<String, String>();
            params.put("objectId", options.getRoot().id());
            JsonNode node = this.realm.environment().client().send("DOM.describeNode", params);
            backendNodeId = node.at("/node/backendNodeId").asText();
        }
        Iterator elements = nodes.elements();
        ArrayList<com.ruiyun.jvppeteer.cdp.entities.AXNode> payloads = new ArrayList<com.ruiyun.jvppeteer.cdp.entities.AXNode>();
        while (elements.hasNext()) {
            JsonNode next = (JsonNode)elements.next();
            payloads.add((com.ruiyun.jvppeteer.cdp.entities.AXNode)Constant.OBJECTMAPPER.treeToValue((TreeNode)next, com.ruiyun.jvppeteer.cdp.entities.AXNode.class));
        }
        AXNode defaultRoot = AXNode.createTree(this.realm, payloads);
        if (Objects.isNull(defaultRoot)) {
            return null;
        }
        if (options.getIncludeIframes()) {
            this.populateIframes(options, defaultRoot);
            if (ValidateUtil.isNotEmpty(defaultRoot.getChildren())) {
                for (AXNode child : defaultRoot.getChildren()) {
                    this.populateIframes(options, child);
                }
            }
        }
        AXNode needle = defaultRoot;
        if (StringUtil.isNotEmpty(backendNodeId) && Objects.isNull(needle = defaultRoot.find(arg_0 -> Accessibility.lambda$snapshot$0(finalBackendNodeId = backendNodeId, arg_0)))) {
            return null;
        }
        if (!options.getInterestingOnly()) {
            return this.serializeTree(needle, null).get(0);
        }
        HashSet<AXNode> interestingNodes = new HashSet<AXNode>();
        this.collectInterestingNodes(interestingNodes, defaultRoot, false);
        if (!interestingNodes.contains(needle)) {
            return null;
        }
        return this.serializeTree(needle, interestingNodes).get(0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void populateIframes(SnapshotOptions options, AXNode defaultRoot) throws JsonProcessingException, IllegalAccessException, IntrospectionException, InvocationTargetException {
        ElementHandle handle;
        if (Objects.nonNull(defaultRoot.getPayload().getRole()) && Objects.equals("Iframe", defaultRoot.getPayload().getRole().getValue()) && Objects.nonNull(defaultRoot.getPayload().getBackendDOMNodeId()) && Objects.nonNull(handle = this.realm.adoptBackendNode(defaultRoot.getPayload().getBackendDOMNodeId()).asElement())) {
            try {
                Frame frame = handle.contentFrame();
                if (Objects.nonNull(frame)) {
                    SerializedAXNode iframeSnapshot = frame.accessibility().snapshot(options);
                    defaultRoot.setIframeSnapshot(iframeSnapshot);
                }
            }
            finally {
                handle.dispose();
            }
        }
    }

    private void collectInterestingNodes(Set<AXNode> collection, AXNode node, boolean insideControl) {
        if (node.isInteresting(insideControl) || Objects.nonNull(node.getIframeSnapshot())) {
            collection.add(node);
        }
        if (node.isLeafNode()) {
            return;
        }
        insideControl = insideControl || node.isControl();
        for (AXNode child : node.getChildren()) {
            this.collectInterestingNodes(collection, child, insideControl);
        }
    }

    private List<SerializedAXNode> serializeTree(AXNode node, Set<AXNode> interestingNodes) throws IllegalAccessException, IntrospectionException, InvocationTargetException, JsonProcessingException {
        ArrayList<SerializedAXNode> children = new ArrayList<SerializedAXNode>();
        if (ValidateUtil.isNotEmpty(node.getChildren())) {
            for (AXNode child : node.getChildren()) {
                children.addAll(this.serializeTree(child, interestingNodes));
            }
        }
        if (ValidateUtil.isNotEmpty(interestingNodes) && !interestingNodes.contains(node)) {
            return children;
        }
        SerializedAXNode serializedNode = node.serialize();
        if (ValidateUtil.isNotEmpty(children)) {
            serializedNode.setChildren(children);
        }
        if (Objects.nonNull(node.getIframeSnapshot())) {
            if (ValidateUtil.isEmpty(serializedNode.getChildren())) {
                serializedNode.setChildren(new ArrayList<SerializedAXNode>());
            }
            serializedNode.getChildren().add(node.getIframeSnapshot());
        }
        ArrayList<SerializedAXNode> result = new ArrayList<SerializedAXNode>();
        result.add(serializedNode);
        return result;
    }

    private static /* synthetic */ boolean lambda$snapshot$0(String finalBackendNodeId, AXNode node) {
        return finalBackendNodeId.equals(node.getPayload().getBackendDOMNodeId() + "");
    }
}

